/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.database.jackson;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.concurrent.ConcurrentHashMap;
import org.bson.UuidRepresentation;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecRegistry;
import org.graylog2.database.jackson.CustomJacksonCodec;
import org.mongojack.JacksonCodecRegistry;
import org.mongojack.internal.stream.JacksonDecoder;
import org.mongojack.internal.stream.JacksonEncoder;

public class CustomJacksonCodecRegistry
extends JacksonCodecRegistry {
    protected final ConcurrentHashMap<Class<?>, Codec<?>> codecCache = new ConcurrentHashMap();
    protected final ObjectMapper objectMapper;

    public CustomJacksonCodecRegistry(ObjectMapper objectMapper, CodecRegistry defaultCodecRegistry) {
        super(objectMapper, defaultCodecRegistry, null, UuidRepresentation.UNSPECIFIED);
        this.objectMapper = objectMapper;
    }

    public <T> Codec<T> addCodecForClass(Class<T> clazz) {
        return this.codecCache.computeIfAbsent(clazz, k -> {
            JacksonEncoder encoder = new JacksonEncoder(clazz, null, this.objectMapper, UuidRepresentation.UNSPECIFIED);
            JacksonDecoder decoder = new JacksonDecoder(clazz, null, this.objectMapper, UuidRepresentation.UNSPECIFIED);
            return new CustomJacksonCodec(encoder, decoder, this.objectMapper, this);
        });
    }
}

