/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.database.jackson.legacy;

import com.google.common.primitives.Ints;
import com.mongodb.MongoException;
import com.mongodb.ReadPreference;
import com.mongodb.client.result.UpdateResult;
import org.bson.BsonValue;
import org.bson.codecs.CollectibleCodec;
import org.mongojack.JacksonMongoCollection;
import org.mongojack.WriteResult;

@Deprecated
public class LegacyUpdateOneResult<T, K>
implements WriteResult<T, K> {
    protected final JacksonMongoCollection<T> collection;
    private final T object;
    private final UpdateResult updateResult;
    private final Class<T> valueType;
    private final Class<K> idType;

    public LegacyUpdateOneResult(JacksonMongoCollection<T> collection, T object, UpdateResult updateResult, Class<T> valueType, Class<K> idType) {
        this.collection = collection.withReadPreference(ReadPreference.primary());
        this.object = object;
        this.updateResult = updateResult;
        this.valueType = valueType;
        this.idType = idType;
    }

    @Override
    public T getSavedObject() {
        if (!this.wasSaved()) {
            throw new MongoException("No objects to return");
        }
        return (T)this.collection.findOneById((Object)this.getId());
    }

    @Override
    public K getSavedId() {
        if (!this.wasSaved()) {
            throw new MongoException("No objects to return");
        }
        return WriteResult.toIdType(this.getId(), this.idType);
    }

    @Override
    public int getN() {
        return this.updateResult.getUpsertedId() != null ? 1 : Ints.saturatedCast((long)this.updateResult.getMatchedCount());
    }

    @Override
    public boolean wasAcknowledged() {
        return this.updateResult.wasAcknowledged();
    }

    @Override
    public Object getUpsertedId() {
        return WriteResult.extractValue(this.updateResult.getUpsertedId());
    }

    @Override
    public boolean isUpdateOfExisting() {
        return this.updateResult.getMatchedCount() > 0L;
    }

    private BsonValue getId() {
        if (this.updateResult.getUpsertedId() != null) {
            return this.updateResult.getUpsertedId();
        }
        CollectibleCodec codec = (CollectibleCodec)this.collection.getCodecRegistry().get(this.valueType);
        return codec.getDocumentId(this.object);
    }

    private boolean wasSaved() {
        return this.updateResult.getUpsertedId() != null || this.updateResult.getMatchedCount() > 0L;
    }
}

