/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.database.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Streams;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.model.Updates;
import com.mongodb.client.result.InsertOneResult;
import jakarta.annotation.Nonnull;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.EncoderContext;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.graylog2.database.MongoEntity;
import org.graylog2.database.jackson.CustomJacksonCodecRegistry;
import org.mongojack.InitializationRequiredForTransformation;
import org.mongojack.JacksonCodecRegistry;

public class MongoUtils<T extends MongoEntity> {
    private final MongoCollection<T> collection;
    private final ObjectMapper objectMapper;
    private final CustomJacksonCodecRegistry codecRegistry;

    public MongoUtils(MongoCollection<T> delegate, ObjectMapper objectMapper) {
        this.collection = delegate;
        this.objectMapper = objectMapper;
        this.codecRegistry = new CustomJacksonCodecRegistry(objectMapper, this.collection.getCodecRegistry());
    }

    public static ObjectId insertedId(@Nonnull InsertOneResult result) {
        BsonValue insertedId = result.getInsertedId();
        if (insertedId == null) {
            throw new IllegalArgumentException("Inserted ID is null. Make sure that you are inserting documents of type <? extends MongoEntity>.");
        }
        return insertedId.asObjectId().getValue();
    }

    public static String insertedIdAsString(@Nonnull InsertOneResult result) {
        return MongoUtils.insertedId(result).toHexString();
    }

    public static Bson idEq(@Nonnull String id) {
        return MongoUtils.idEq(new ObjectId(id));
    }

    public static Bson idEq(@Nonnull ObjectId id) {
        return Filters.eq((String)"_id", (Object)id);
    }

    public static Bson objectIdEq(@Nonnull String fieldName, @Nonnull String id) {
        return MongoUtils.objectIdEq(fieldName, new ObjectId(id));
    }

    public static Bson objectIdEq(@Nonnull String fieldName, @Nonnull ObjectId objectId) {
        return Filters.eq((String)fieldName, (Object)objectId);
    }

    public static Bson stringIdsIn(Collection<String> ids) {
        return MongoUtils.idsIn(ids.stream().map(ObjectId::new).collect(Collectors.toSet()));
    }

    public static Bson idsIn(Collection<ObjectId> ids) {
        return Filters.in((String)"_id", ids);
    }

    public static <T> Stream<T> stream(@Nonnull MongoIterable<T> mongoIterable) {
        MongoCursor cursor = mongoIterable.cursor();
        return (Stream)Streams.stream((Iterator)cursor).onClose(() -> ((MongoCursor)cursor).close());
    }

    public Optional<T> getById(ObjectId id) {
        return Optional.ofNullable((MongoEntity)this.collection.find(MongoUtils.idEq(id)).first());
    }

    public Optional<T> getById(String id) {
        return this.getById(new ObjectId(id));
    }

    public boolean deleteById(ObjectId id) {
        return this.collection.deleteOne(MongoUtils.idEq(id)).getDeletedCount() > 0L;
    }

    public boolean deleteById(String id) {
        return this.deleteById(new ObjectId(id));
    }

    public T getOrCreate(T entity) {
        Objects.requireNonNull(entity, "entity cannot be null");
        ObjectId entityId = new ObjectId(Objects.requireNonNull(entity.id(), "entity ID cannot be null"));
        Codec codec = this.collection.getCodecRegistry().get(this.collection.getDocumentClass());
        try (BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());){
            codec.encode((BsonWriter)writer, entity, EncoderContext.builder().build());
            MongoEntity mongoEntity = (MongoEntity)this.collection.findOneAndUpdate(MongoUtils.idEq(entityId), Updates.setOnInsert((Bson)writer.getDocument()), new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER).upsert(true));
            return (T)mongoEntity;
        }
    }

    @Deprecated
    public void initializeLegacyMongoJackBsonObject(InitializationRequiredForTransformation mongoJackBsonObject) {
        mongoJackBsonObject.initialize(this.objectMapper, this.objectMapper.constructType((Type)this.collection.getDocumentClass()), (JacksonCodecRegistry)this.codecRegistry);
    }
}

