/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.datatiering.hotonly;

import com.google.common.base.Preconditions;
import jakarta.inject.Inject;
import jakarta.validation.constraints.NotNull;
import java.util.Optional;
import org.graylog2.configuration.ElasticsearchConfiguration;
import org.graylog2.datatiering.DataTieringConfig;
import org.graylog2.datatiering.DataTieringOrchestrator;
import org.graylog2.datatiering.fallback.FallbackDataTieringConfig;
import org.graylog2.datatiering.retention.DataTierDeleteRetention;
import org.graylog2.datatiering.rotation.DataTierRotation;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.IndexSetValidator;
import org.graylog2.indexer.rotation.tso.IndexLifetimeConfig;
import org.graylog2.indexer.rotation.tso.TimeSizeOptimizingValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HotOnlyDataTieringOrchestrator
implements DataTieringOrchestrator {
    private static final Logger LOG = LoggerFactory.getLogger(HotOnlyDataTieringOrchestrator.class);
    private final ElasticsearchConfiguration elasticsearchConfiguration;
    private final DataTierRotation.Factory dataTierRotationFactory;
    private final DataTierDeleteRetention dataTierDeleteRetention;

    @Inject
    public HotOnlyDataTieringOrchestrator(ElasticsearchConfiguration elasticsearchConfiguration, DataTierRotation.Factory dataTierRotationFactory, DataTierDeleteRetention dataTierDeleteRetention) {
        this.elasticsearchConfiguration = elasticsearchConfiguration;
        this.dataTierRotationFactory = dataTierRotationFactory;
        this.dataTierDeleteRetention = dataTierDeleteRetention;
    }

    private static IndexLifetimeConfig toIndexLifetimeConfig(DataTieringConfig config) {
        return IndexLifetimeConfig.builder().indexLifetimeMin(config.indexLifetimeMin()).indexLifetimeMax(config.indexLifetimeMax()).build();
    }

    @Override
    public void rotate(IndexSet indexSet) {
        DataTieringConfig dataTieringConfig = indexSet.getConfig().dataTieringConfig();
        Preconditions.checkNotNull((Object)dataTieringConfig);
        DataTierRotation dataTierRotation = this.dataTierRotationFactory.create(HotOnlyDataTieringOrchestrator.toIndexLifetimeConfig(dataTieringConfig));
        dataTierRotation.rotate(indexSet);
    }

    @Override
    public void retain(IndexSet indexSet) {
        DataTieringConfig dataTieringConfig = indexSet.getConfig().dataTieringConfig();
        Preconditions.checkNotNull((Object)dataTieringConfig);
        if (dataTieringConfig instanceof FallbackDataTieringConfig) {
            LOG.warn("An enterprise data tier configuration is used for index '{}', enterprise properties are ignored! Please update the configuration for this index set.", (Object)indexSet.getConfig().title());
        }
        this.dataTierDeleteRetention.retain(indexSet, HotOnlyDataTieringOrchestrator.toIndexLifetimeConfig(dataTieringConfig));
    }

    @Override
    public Optional<IndexSetValidator.Violation> validate(@NotNull DataTieringConfig config) {
        Preconditions.checkNotNull((Object)config);
        return TimeSizeOptimizingValidator.validate(this.elasticsearchConfiguration, HotOnlyDataTieringOrchestrator.toIndexLifetimeConfig(config));
    }
}

