/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.datatiering.rotation;

import com.github.joschi.jadconfig.util.Size;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.time.Duration;
import java.time.Instant;
import javax.annotation.Nonnull;
import org.graylog.scheduler.clock.JobSchedulerClock;
import org.graylog2.configuration.ElasticsearchConfiguration;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.indexer.retention.strategies.NoopRetentionStrategyConfig;
import org.graylog2.indexer.rotation.common.IndexRotator;
import org.graylog2.indexer.rotation.tso.IndexLifetimeConfig;
import org.graylog2.shared.utilities.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;

public class DataTierRotation {
    private final JobSchedulerClock clock;
    private final Period rotationPeriod;
    private final Indices indices;
    private final IndexRotator indexRotator;
    private final Size maxShardSize;
    private final Size minShardSize;
    private final IndexLifetimeConfig indexLifetimeConfig;

    @AssistedInject
    public DataTierRotation(Indices indices, ElasticsearchConfiguration elasticsearchConfiguration, IndexRotator indexRotator, JobSchedulerClock clock, @Assisted IndexLifetimeConfig indexLifetimeConfig) {
        this.indices = indices;
        this.indexRotator = indexRotator;
        this.clock = clock;
        this.rotationPeriod = elasticsearchConfiguration.getTimeSizeOptimizingRotationPeriod();
        this.maxShardSize = elasticsearchConfiguration.getTimeSizeOptimizingRotationMaxShardSize();
        this.minShardSize = elasticsearchConfiguration.getTimeSizeOptimizingRotationMinShardSize();
        this.indexLifetimeConfig = indexLifetimeConfig;
    }

    public void rotate(IndexSet indexSet) {
        this.indexRotator.rotate(indexSet, this::shouldRotate);
    }

    private IndexRotator.Result createResult(boolean shouldRotate, String message) {
        return IndexRotator.createResult(shouldRotate, message, this.getClass().getCanonicalName());
    }

    @Nonnull
    private IndexRotator.Result shouldRotate(String index, IndexSet indexSet) {
        Period leeWay;
        DateTime creationDate = this.indices.indexCreationDate(index).orElseThrow(() -> new IllegalStateException("No index creation date"));
        Long sizeInBytes = this.indices.getStoreSizeInBytes(index).orElseThrow(() -> new IllegalStateException("No index size"));
        if (this.indices.numberOfMessages(index) == 0L) {
            return this.createResult(false, "Index is empty");
        }
        int shards = indexSet.getConfig().shards();
        long maxIndexSize = this.maxShardSize.toBytes() * (long)shards;
        if (sizeInBytes > maxIndexSize) {
            return this.createResult(true, StringUtils.f("Index size <%s> exceeds maximum size <%s>", StringUtils.humanReadableByteCount(sizeInBytes), StringUtils.humanReadableByteCount(maxIndexSize)));
        }
        if (!(indexSet.getConfig().retentionStrategyConfig() instanceof NoopRetentionStrategyConfig) && this.indexExceedsLeeWay(creationDate, leeWay = this.indexLifetimeConfig.indexLifetimeMax().minus((ReadablePeriod)this.indexLifetimeConfig.indexLifetimeMin()))) {
            return this.createResult(true, StringUtils.f("Index creation date <%s> exceeds optimization leeway <%s>", creationDate, leeWay));
        }
        long minIndexSize = this.minShardSize.toBytes() * (long)shards;
        if (this.indexIsOldEnough(creationDate) && sizeInBytes >= minIndexSize) {
            return this.createResult(true, StringUtils.f("Index creation date <%s> has passed rotation period <%s> and has a reasonable size <%s> for rotation", creationDate, this.rotationPeriod, StringUtils.humanReadableByteCount(minIndexSize)));
        }
        return this.createResult(false, "No reason to rotate found");
    }

    private boolean indexExceedsLeeWay(DateTime creationDate, Period leeWay) {
        return this.timePassedIsBeyondLimit(creationDate, leeWay);
    }

    private boolean indexIsOldEnough(DateTime creationDate) {
        return this.timePassedIsBeyondLimit(creationDate, this.rotationPeriod);
    }

    private boolean timePassedIsBeyondLimit(DateTime date, Period limit) {
        Duration limitAsDuration;
        Instant now = this.clock.instantNow();
        Duration timePassed = Duration.between(Instant.ofEpochMilli(date.getMillis()), now);
        return timePassed.compareTo(limitAsDuration = Duration.ofSeconds(limit.toStandardSeconds().getSeconds())) >= 0;
    }

    public static interface Factory {
        public DataTierRotation create(IndexLifetimeConfig var1);
    }
}

