/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.decorators;

import com.google.common.collect.ImmutableMap;
import com.google.inject.assistedinject.Assisted;
import io.opentelemetry.instrumentation.annotations.WithSpan;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.graylog2.decorators.Decorator;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.MessageFactory;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.configuration.fields.TextField;
import org.graylog2.plugin.decorators.SearchResponseDecorator;
import org.graylog2.rest.models.messages.responses.ResultMessageSummary;
import org.graylog2.rest.resources.search.responses.SearchResponse;

public class SyslogSeverityMapperDecorator
implements SearchResponseDecorator {
    private static final String CK_SOURCE_FIELD = "source_field";
    private static final String CK_TARGET_FIELD = "target_field";
    private static final Map<String, String> SYSLOG_MAPPING = ImmutableMap.builder().put((Object)"0", (Object)"Emergency (0)").put((Object)"1", (Object)"Alert (1)").put((Object)"2", (Object)"Critical (2)").put((Object)"3", (Object)"Error (3)").put((Object)"4", (Object)"Warning (4)").put((Object)"5", (Object)"Notice (5)").put((Object)"6", (Object)"Informational (6)").put((Object)"7", (Object)"Debug (7)").build();
    private final String sourceField;
    private final String targetField;
    private final MessageFactory messageFactory;

    @Inject
    public SyslogSeverityMapperDecorator(@Assisted Decorator decorator, MessageFactory messageFactory) {
        this.sourceField = (String)Objects.requireNonNull(decorator.config().get(CK_SOURCE_FIELD), "source_field cannot be null");
        this.targetField = (String)Objects.requireNonNull(decorator.config().get(CK_TARGET_FIELD), "target_field cannot be null");
        this.messageFactory = messageFactory;
    }

    @Override
    @WithSpan
    public SearchResponse apply(SearchResponse searchResponse) {
        List<ResultMessageSummary> summaries = searchResponse.messages().stream().map(summary -> {
            if (!summary.message().containsKey(this.sourceField)) {
                return summary;
            }
            String level = String.valueOf(summary.message().get(this.sourceField));
            String severity = SYSLOG_MAPPING.get(level);
            if (severity == null) {
                return summary;
            }
            Message message = this.messageFactory.createMessage((Map<String, Object>)ImmutableMap.copyOf(summary.message()));
            message.addField(this.targetField, severity);
            return summary.toBuilder().message(message.getFields()).build();
        }).collect(Collectors.toList());
        return searchResponse.toBuilder().messages(summaries).build();
    }

    public static class Descriptor
    extends SearchResponseDecorator.Descriptor {
        public Descriptor() {
            super("Syslog Severity Mapper", "http://docs.graylog.org/", "Syslog Severity Mapper");
        }
    }

    public static class Config
    implements SearchResponseDecorator.Config {
        @Override
        public ConfigurationRequest getRequestedConfiguration() {
            return new ConfigurationRequest(){
                {
                    this.addField(new TextField(SyslogSeverityMapperDecorator.CK_SOURCE_FIELD, "Source field", "level", "The message field which includes the numeric Syslog severity.", new TextField.Attribute[0]));
                    this.addField(new TextField(SyslogSeverityMapperDecorator.CK_TARGET_FIELD, "Target field", "severity", "The message field that will be created with the mapped severity value.", new TextField.Attribute[0]));
                }
            };
        }
    }

    public static interface Factory
    extends SearchResponseDecorator.Factory {
        @Override
        public SyslogSeverityMapperDecorator create(Decorator var1);

        @Override
        public Config getConfig();

        @Override
        public Descriptor getDescriptor();
    }
}

