/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.featureflag;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;

class FeatureFlagsResources {
    FeatureFlagsResources() {
    }

    Map<String, String> defaultProperties(String file) throws IOException {
        return this.loadProperties(FeatureFlagsResources.class.getResourceAsStream(file));
    }

    Map<String, String> customProperties(String file) throws IOException {
        return this.loadProperties(new FileInputStream(file));
    }

    private Map<String, String> loadProperties(InputStream inputStream) throws IOException {
        Properties properties = new Properties();
        properties.load(inputStream);
        return FeatureFlagsResources.toMap(properties);
    }

    Map<String, String> systemProperties() {
        return FeatureFlagsResources.toMap(System.getProperties());
    }

    Map<String, String> environmentVariables() {
        return System.getenv();
    }

    private static Map<String, String> toMap(Properties properties) {
        return properties.stringPropertyNames().stream().collect(Collectors.toMap(Function.identity(), properties::getProperty));
    }
}

