/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.filters;

import com.google.common.collect.ImmutableList;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import org.graylog2.database.NotFoundException;
import org.graylog2.inputs.Input;
import org.graylog2.inputs.InputService;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.filters.MessageFilter;
import org.graylog2.plugin.lifecycles.Lifecycle;
import org.graylog2.rest.models.system.inputs.responses.InputCreated;
import org.graylog2.rest.models.system.inputs.responses.InputDeleted;
import org.graylog2.rest.models.system.inputs.responses.InputUpdated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticFieldFilter
implements MessageFilter {
    private static final Logger LOG = LoggerFactory.getLogger(StaticFieldFilter.class);
    private static final String NAME = "Static field appender";
    private final ConcurrentMap<String, List<Map.Entry<String, String>>> staticFields = new ConcurrentHashMap<String, List<Map.Entry<String, String>>>();
    private final InputService inputService;
    private final ScheduledExecutorService scheduler;

    @Inject
    public StaticFieldFilter(InputService inputService, EventBus serverEventBus, @Named(value="daemonScheduler") ScheduledExecutorService scheduler) {
        this.inputService = inputService;
        this.scheduler = scheduler;
        serverEventBus.register((Object)this);
    }

    @Override
    public boolean filter(Message msg) {
        if (msg.getSourceInputId() == null) {
            return false;
        }
        for (Map.Entry field : this.staticFields.getOrDefault(msg.getSourceInputId(), Collections.emptyList())) {
            if (!msg.hasField((String)field.getKey())) {
                msg.addField((String)field.getKey(), field.getValue());
                continue;
            }
            LOG.debug("Message already contains field [{}]. Not overwriting.", field.getKey());
        }
        return false;
    }

    @Subscribe
    public void handleInputCreate(InputCreated event) {
        LOG.debug("Load static fields for input <{}>", (Object)event.id());
        this.scheduler.submit(() -> this.loadStaticFields(event.id()));
    }

    @Subscribe
    public void handleInputDelete(InputDeleted event) {
        LOG.debug("Removing input from static fields cache <{}>", (Object)event.id());
        this.staticFields.remove(event.id());
    }

    @Subscribe
    public void handleInputUpdate(InputUpdated event) {
        this.scheduler.submit(() -> this.loadStaticFields(event.id()));
    }

    @Subscribe
    public void lifecycleChanged(Lifecycle lifecycle) {
        if (Lifecycle.STARTING.equals((Object)lifecycle)) {
            this.loadAllStaticFields();
        }
    }

    private void loadAllStaticFields() {
        try {
            this.inputService.all().forEach(input -> this.loadStaticFields(input.getId()));
        }
        catch (Exception e) {
            LOG.error("Unable to load static fields for all inputs", (Throwable)e);
        }
    }

    private void loadStaticFields(String inputId) {
        LOG.debug("Re-loading static fields for input <{}> into cache.", (Object)inputId);
        try {
            Input input = this.inputService.find(inputId);
            this.staticFields.put(inputId, (List<Map.Entry<String, String>>)ImmutableList.copyOf(this.inputService.getStaticFields(input)));
        }
        catch (NotFoundException e) {
            LOG.warn("Unable to load input: {}", (Object)e.getMessage());
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getPriority() {
        return 20;
    }
}

