/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer;

import jakarta.annotation.Nonnull;
import org.graylog2.indexer.ElasticsearchException;
import org.graylog2.indexer.IgnoreIndexTemplate;
import org.graylog2.indexer.IndexMappingTemplate;
import org.graylog2.indexer.IndexTemplateProvider;
import org.graylog2.indexer.indexset.IndexSetConfig;
import org.graylog2.storage.SearchVersion;

public abstract class BasicIndexTemplateProvider<T extends IndexMappingTemplate>
implements IndexTemplateProvider<T> {
    @Override
    @Nonnull
    public T create(@Nonnull SearchVersion searchVersion, IndexSetConfig indexSetConfig) throws IgnoreIndexTemplate {
        if (this.isProperSearchVersion(searchVersion)) {
            return this.createTemplateInstance();
        }
        throw new ElasticsearchException("Unsupported Search version: " + searchVersion);
    }

    private boolean isProperSearchVersion(@Nonnull SearchVersion searchVersion) {
        return searchVersion.satisfies(SearchVersion.Distribution.ELASTICSEARCH, "^7.0.0") || searchVersion.satisfies(SearchVersion.Distribution.OPENSEARCH, "^1.0.0 | ^2.0.0") || searchVersion.satisfies(SearchVersion.Distribution.DATANODE, "^5.2.0");
    }

    protected abstract T createTemplateInstance();
}

