/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.datanode;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.graylog2.database.MongoEntity;
import org.graylog2.indexer.datanode.IndexMigrationConfiguration;
import org.graylog2.indexer.migration.LogEntry;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.mongojack.Id;
import org.mongojack.ObjectId;

public record MigrationConfiguration(@ObjectId @Id @Nullable @JsonProperty(value="id") String id, @JsonProperty(value="created") DateTime created, @JsonProperty(value="indices") List<IndexMigrationConfiguration> indices, @JsonProperty(value="certificates") List<String> certificates, @JsonProperty(value="logs") List<LogEntry> logs) implements MongoEntity
{
    public static final String FIELD_ID = "id";
    public static final String FIELD_INDICES = "indices";
    public static final String FIELD_CREATED = "created";
    public static final String FIELD_LOGS = "logs";
    public static final String FIELD_CERTIFICATES = "certificates";

    public static MigrationConfiguration forIndices(List<String> indices, List<String> trustedCertificates) {
        return new MigrationConfiguration(null, new DateTime(DateTimeZone.UTC), indices.stream().map(indexName -> new IndexMigrationConfiguration((String)indexName, null)).collect(Collectors.toList()), trustedCertificates, Collections.emptyList());
    }

    @JsonIgnore
    public Optional<IndexMigrationConfiguration> getConfigForIndexName(String indexName) {
        return this.indices.stream().filter(i -> Objects.equals(i.indexName(), indexName)).findFirst();
    }
}

