/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.indexset;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.Min;
import javax.annotation.Nullable;
import org.graylog2.datatiering.DataTieringConfig;
import org.graylog2.plugin.indexer.retention.RetentionStrategyConfig;
import org.graylog2.plugin.indexer.rotation.RotationStrategyConfig;
import org.joda.time.Duration;

public interface SimpleIndexSetConfig {
    public static final Duration DEFAULT_FIELD_TYPE_REFRESH_INTERVAL = Duration.standardSeconds((long)5L);
    public static final String FIELD_TITLE = "title";
    public static final String FIELD_DESCRIPTION = "description";
    public static final String FIELD_WRITABLE = "writable";
    public static final String FIELD_SHARDS = "shards";
    public static final String FIELD_REPLICAS = "replicas";
    public static final String FIELD_ROTATION_STRATEGY_CLASS = "rotation_strategy_class";
    public static final String FIELD_ROTATION_STRATEGY = "rotation_strategy";
    public static final String FIELD_RETENTION_STRATEGY_CLASS = "retention_strategy_class";
    public static final String FIELD_RETENTION_STRATEGY = "retention_strategy";
    public static final String FIELD_INDEX_ANALYZER = "index_analyzer";
    public static final String FIELD_INDEX_OPTIMIZATION_MAX_NUM_SEGMENTS = "index_optimization_max_num_segments";
    public static final String FIELD_INDEX_OPTIMIZATION_DISABLED = "index_optimization_disabled";
    public static final String FIELD_DATA_TIERING = "data_tiering";
    public static final String INDEX_PREFIX_REGEX = "^[a-z0-9][a-z0-9_+-]*$";
    public static final String FIELD_INDEX_PREFIX = "index_prefix";
    public static final String FIELD_CREATION_DATE = "creation_date";
    public static final String FIELD_INDEX_TEMPLATE_TYPE = "index_template_type";
    public static final String FIELD_TYPE_REFRESH_INTERVAL = "field_type_refresh_interval";
    public static final String FIELD_USE_LEGACY_ROTATION = "use_legacy_rotation";
    public static final String FIELD_PROFILE_ID = "field_type_profile";

    @Min(value=1L)
    @JsonProperty(value="shards")
    public @Min(value=1L) int shards();

    @Min(value=0L)
    @JsonProperty(value="replicas")
    public @Min(value=0L) int replicas();

    @Min(value=1L)
    @JsonProperty(value="index_optimization_max_num_segments")
    public @Min(value=1L) int indexOptimizationMaxNumSegments();

    @JsonProperty(value="index_optimization_disabled")
    public boolean indexOptimizationDisabled();

    @JsonProperty(value="field_type_refresh_interval")
    public Duration fieldTypeRefreshInterval();

    @Nullable
    @JsonProperty(value="rotation_strategy_class")
    public String rotationStrategyClass();

    @Nullable
    @JsonProperty(value="rotation_strategy")
    public RotationStrategyConfig rotationStrategyConfig();

    @Nullable
    @JsonProperty(value="retention_strategy_class")
    public String retentionStrategyClass();

    @Nullable
    @JsonProperty(value="retention_strategy")
    public RetentionStrategyConfig retentionStrategyConfig();

    @Nullable
    @JsonProperty(value="data_tiering")
    public DataTieringConfig dataTieringConfig();
}

