/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.indexset.template;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.Resources;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.graylog2.Configuration;
import org.graylog2.indexer.indexset.template.IndexSetTemplate;
import org.graylog2.shared.utilities.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class IndexSetTemplateProvider {
    private static final Logger LOG = LoggerFactory.getLogger(IndexSetTemplateProvider.class);
    private static final String ON_PREM_TEMPLATE_RESOURCE = "on_prem_templates.json";
    protected final ObjectMapper objectMapper;
    private List<IndexSetTemplate> templates;

    @Inject
    IndexSetTemplateProvider(ObjectMapper objectMapper, Configuration configuration) {
        this.objectMapper = objectMapper;
        if (configuration.isCloud()) {
            this.templates = Collections.emptyList();
        } else {
            try {
                this.templates = (List)objectMapper.readerForListOf(IndexSetTemplate.class).readValue(this.getResourceUrl(ON_PREM_TEMPLATE_RESOURCE));
            }
            catch (IOException e) {
                LOG.error("Error reading index set templates from {}", (Object)ON_PREM_TEMPLATE_RESOURCE, (Object)e);
                this.templates = Collections.emptyList();
            }
        }
    }

    public List<IndexSetTemplate> get() {
        return this.templates;
    }

    private URL getResourceUrl(String resourceName) {
        URL url = Resources.getResource(this.getClass(), (String)resourceName);
        if (url == null) {
            throw new IllegalArgumentException(StringUtils.f("Unable to find resource: %s", resourceName));
        }
        return url;
    }
}

