/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.retention.executors;

import jakarta.inject.Inject;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.indexer.retention.executors.RetentionExecutor;
import org.graylog2.shared.system.activities.Activity;
import org.graylog2.shared.system.activities.ActivityWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CountBasedRetentionExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(CountBasedRetentionExecutor.class);
    private final Indices indices;
    private final ActivityWriter activityWriter;
    private final RetentionExecutor retentionExecutor;

    @Inject
    public CountBasedRetentionExecutor(Indices indices, ActivityWriter activityWriter, RetentionExecutor retentionExecutor) {
        this.indices = indices;
        this.activityWriter = activityWriter;
        this.retentionExecutor = retentionExecutor;
    }

    public void retain(IndexSet indexSet, @Nullable Integer maxNumberOfIndices, RetentionExecutor.RetentionAction action, String actionName) {
        Map<String, Set<String>> deflectorIndices = indexSet.getAllIndexAliases();
        int indexCount = (int)deflectorIndices.keySet().stream().filter(indexName -> !this.indices.isReopened((String)indexName)).count();
        if (maxNumberOfIndices == null) {
            LOG.warn("No retention strategy configuration found, not running index retention!");
            return;
        }
        if (indexCount <= maxNumberOfIndices) {
            LOG.debug("Number of indices ({}) lower than limit ({}). Not performing any retention actions.", (Object)indexCount, (Object)maxNumberOfIndices);
            return;
        }
        int removeCount = indexCount - maxNumberOfIndices;
        String msg = "Number of indices (" + indexCount + ") higher than limit (" + maxNumberOfIndices + "). Running retention for " + removeCount + " indices.";
        LOG.info(msg);
        this.activityWriter.write(new Activity(msg, CountBasedRetentionExecutor.class));
        this.retentionExecutor.runRetention(indexSet, removeCount, action, actionName);
    }
}

