/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs;

import com.google.common.collect.Lists;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Iterator;
import org.graylog2.database.NotFoundException;
import org.graylog2.inputs.Input;
import org.graylog2.inputs.InputService;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.shared.inputs.NoSuchInputTypeException;
import org.graylog2.shared.inputs.PersistedInputs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistedInputsImpl
implements PersistedInputs {
    private static final Logger LOG = LoggerFactory.getLogger(PersistedInputsImpl.class);
    private final InputService inputService;
    private final ServerStatus serverStatus;

    @Inject
    public PersistedInputsImpl(InputService inputService, ServerStatus serverStatus) {
        this.inputService = inputService;
        this.serverStatus = serverStatus;
    }

    @Override
    public Iterator<MessageInput> iterator() {
        ArrayList result = Lists.newArrayList();
        for (Input io : this.inputService.allOfThisNode(this.serverStatus.getNodeId().toString())) {
            try {
                MessageInput input = this.inputService.getMessageInput(io);
                result.add(input);
            }
            catch (NoSuchInputTypeException e) {
                LOG.warn("Cannot instantiate persisted input. No such type [{}].", (Object)io.getType());
            }
            catch (Throwable e) {
                LOG.warn("Cannot instantiate persisted input. Exception caught: ", e);
            }
        }
        return result.iterator();
    }

    @Override
    public MessageInput get(String id) {
        try {
            return this.inputService.getMessageInput(this.inputService.find(id));
        }
        catch (NoSuchInputTypeException e) {
            LOG.warn("Cannot instantiate persisted input: ", (Throwable)e);
        }
        catch (NotFoundException e) {
            LOG.warn("Cannot find persisted Input with id {}", (Object)id);
        }
        return null;
    }
}

