/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.jackson;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.graylog2.shared.utilities.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonModelValidator {
    private static final Logger LOG = LoggerFactory.getLogger(JacksonModelValidator.class);

    public static void check(String collectionName, ObjectMapper objectMapper, Class<?> clazz) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("CHECK [{}] {}", (Object)collectionName, (Object)clazz.getCanonicalName());
        }
        SerializationConfig config = objectMapper.getSerializationConfig();
        AnnotationIntrospector ai = config.getAnnotationIntrospector();
        BeanDescription beanDesc = config.introspect(objectMapper.constructType(clazz));
        try {
            objectMapper.getSerializerProviderInstance().findTypedValueSerializer(clazz, true, null);
        }
        catch (JsonMappingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
        if (beanDesc.getBeanClass().isAnnotationPresent(JsonSubTypes.class)) {
            List subtypes;
            if (LOG.isDebugEnabled()) {
                LOG.debug("ITERATE SUBTYPES [{}] {}", (Object)collectionName, (Object)clazz.getCanonicalName());
            }
            if ((subtypes = ai.findSubtypes((Annotated)beanDesc.getClassInfo())) != null) {
                for (NamedType subtype : subtypes) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("CHECK SUBTYPE [{}] {} -> {}", new Object[]{collectionName, clazz.getCanonicalName(), subtype.getType().getCanonicalName()});
                    }
                    JacksonModelValidator.check(collectionName, objectMapper, subtype.getType());
                }
            }
        }
    }

    public static BeanSerializerModifier getBeanSerializerModifier() {
        return new ModelValidationBeanSerializerModifier();
    }

    private static class ModelValidationBeanSerializerModifier
    extends BeanSerializerModifier {
        private ModelValidationBeanSerializerModifier() {
        }

        public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
            AnnotatedClass annotatedClass = beanDesc.getClassInfo();
            if (annotatedClass.hasAnnotation(JsonTypeInfo.class)) {
                Set fieldNames = beanDesc.findProperties().stream().map(BeanPropertyDefinition::getName).collect(Collectors.toSet());
                JsonTypeInfo jsonTypeInfo = (JsonTypeInfo)annotatedClass.getAnnotation(JsonTypeInfo.class);
                switch (jsonTypeInfo.include()) {
                    case PROPERTY: {
                        if (fieldNames.contains(jsonTypeInfo.property())) {
                            throw new RuntimeException(StringUtils.f("JsonTypeInfo#property value conflicts with existing property: %s (class %s)", jsonTypeInfo.property(), annotatedClass.getName()));
                        }
                        if (jsonTypeInfo.use() != JsonTypeInfo.Id.NAME || !annotatedClass.hasAnnotation(JsonSubTypes.class) || annotatedClass.hasAnnotation(JsonTypeIdResolver.class)) break;
                        List<String> invalidClasses = Arrays.stream(((JsonSubTypes)annotatedClass.getAnnotation(JsonSubTypes.class)).value()).map(JsonSubTypes.Type::value).map(arg_0 -> ((SerializationConfig)config).constructType(arg_0)).filter(JavaType::isAbstract).map(JavaType::getRawClass).filter(clazz -> !clazz.isAnnotationPresent(JsonTypeName.class)).map(Class::getCanonicalName).toList();
                        if (invalidClasses.isEmpty()) break;
                        throw new RuntimeException(StringUtils.f("@JsonSubTypes.Type values that are abstract classes (e.g., auto-value) must have a @JsonTypeName annotation or a custom @JsonTypeIdResolver. Affected classes: %s", invalidClasses));
                    }
                    case EXISTING_PROPERTY: {
                        if (fieldNames.contains(jsonTypeInfo.property())) break;
                        throw new RuntimeException(StringUtils.f("JsonTypeInfo#property value doesn't exist as property: %s (class %s)", jsonTypeInfo.property(), annotatedClass.getName()));
                    }
                }
            }
            return beanProperties;
        }
    }
}

