/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import java.io.IOException;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Date;
import java.util.Locale;

public final class MongoZonedDateTimeDeserializer
extends StdScalarDeserializer<ZonedDateTime> {
    private static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE_TIME).appendOffset("+HHmm", "Z").toFormatter(Locale.US);

    public MongoZonedDateTimeDeserializer() {
        super(ZonedDateTime.class);
    }

    public ZonedDateTime deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        switch (jsonParser.currentToken()) {
            case VALUE_EMBEDDED_OBJECT: {
                Object embeddedObject = jsonParser.getEmbeddedObject();
                if (embeddedObject instanceof Date) {
                    Date date = (Date)embeddedObject;
                    return ZonedDateTime.ofInstant(date.toInstant(), ZoneOffset.UTC);
                }
                throw new IllegalStateException("Unsupported token: " + jsonParser.currentToken());
            }
            case VALUE_STRING: {
                String text = jsonParser.getText();
                return ZonedDateTime.parse(text, FORMATTER).withZoneSameInstant(ZoneOffset.UTC);
            }
        }
        throw new IllegalStateException("Unsupported token: " + jsonParser.currentToken());
    }
}

