/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.log4j;

import com.github.luben.zstd.ZstdInputStream;
import com.github.luben.zstd.ZstdOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryLimitedCompressingFifoRingBuffer {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryLimitedCompressingFifoRingBuffer.class);
    public static final int DEFAULT_ZSTD_COMPRESSION_LEVEL = 1;
    public static final int BATCHSIZE = 512;
    private final ArrayList<byte[]> currentBatch = new ArrayList(512);
    private final MemoryLimitedFifoRingBuffer compressedRingBuffer;
    private final int zStdCompressionLevel;
    private ZstdOutputStream compressedStream;
    private ByteArrayOutputStream outputStreamBuffer;

    public MemoryLimitedCompressingFifoRingBuffer(long memLimit) {
        this(memLimit, 1);
    }

    public MemoryLimitedCompressingFifoRingBuffer(long memLimit, int zStdCompressionLevel) {
        this.compressedRingBuffer = new MemoryLimitedFifoRingBuffer(memLimit);
        this.zStdCompressionLevel = zStdCompressionLevel;
    }

    public synchronized void add(byte[] element) throws IOException {
        if (this.currentBatch.size() >= 512) {
            this.flush();
        }
        this.currentBatch.add(element);
        this.writeIntoCompressedStream(element);
    }

    private void writeIntoCompressedStream(byte[] element) throws IOException {
        if (this.compressedStream == null) {
            this.setUpCompressedStream();
        }
        this.compressedStream.write(element);
    }

    private void setUpCompressedStream() throws IOException {
        this.outputStreamBuffer = new ByteArrayOutputStream(8192);
        this.compressedStream = new ZstdOutputStream((OutputStream)this.outputStreamBuffer, this.zStdCompressionLevel);
    }

    private void flush() throws IOException {
        this.compressedStream.close();
        this.compressedRingBuffer.add(this.outputStreamBuffer.toByteArray());
        this.currentBatch.clear();
        this.setUpCompressedStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamContent(OutputStream outputStream, int limit) {
        List<byte[]> compressed;
        List<byte[]> current;
        MemoryLimitedCompressingFifoRingBuffer memoryLimitedCompressingFifoRingBuffer = this;
        synchronized (memoryLimitedCompressingFifoRingBuffer) {
            current = List.copyOf(this.currentBatch);
            compressed = List.copyOf(this.compressedRingBuffer);
        }
        limit = limit == 0 ? Integer.MAX_VALUE : limit;
        int currentBatchSize = current.size();
        int skipFromCurrent = limit - currentBatchSize;
        skipFromCurrent = skipFromCurrent > 0 ? 0 : skipFromCurrent * -1;
        long getCompressedBatches = (limit -= currentBatchSize) > 0 ? (long)(limit / 512 + 1) : 0L;
        long skipFromCompressed = getCompressedBatches - (long)compressed.size();
        skipFromCompressed = skipFromCompressed > 0L ? 0L : skipFromCompressed * -1L;
        compressed.stream().skip(skipFromCompressed).map(input -> {
            try {
                return this.decompress((byte[])input);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).forEach(b -> {
            try {
                outputStream.write((byte[])b);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        current.stream().skip(skipFromCurrent).forEach(b -> {
            try {
                outputStream.write((byte[])b);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private byte[] decompress(byte[] input) throws IOException {
        ZstdInputStream zstdInputStream = new ZstdInputStream((InputStream)new ByteArrayInputStream(input));
        return zstdInputStream.readAllBytes();
    }

    public synchronized void clear() throws IOException {
        this.currentBatch.clear();
        this.compressedRingBuffer.clear();
        this.compressedStream.close();
        this.compressedStream = null;
        this.outputStreamBuffer = null;
    }

    public long getLogsSize() {
        Integer currentBatchSize = this.currentBatch.stream().map(b -> ((byte[])b).length).reduce(Integer::sum).orElse(0);
        return this.compressedRingBuffer.currentSize * 3L + (long)currentBatchSize.intValue();
    }

    static class MemoryLimitedFifoRingBuffer
    extends LinkedList<byte[]> {
        private final long memLimit;
        private long currentSize;

        public MemoryLimitedFifoRingBuffer(long memLimit) {
            this.memLimit = memLimit;
            this.currentSize = 0L;
        }

        @Override
        public boolean add(byte[] element) {
            while (this.currentSize + (long)element.length > this.memLimit) {
                try {
                    this.removeFirst();
                }
                catch (NoSuchElementException ignored) {
                    LOG.warn("Buffer size <{}> too small to hold a single message of size <{}>", (Object)this.memLimit, (Object)element.length);
                    return false;
                }
            }
            this.currentSize += (long)element.length;
            return super.add(element);
        }

        @Override
        public boolean remove(Object o) {
            boolean removed = super.remove(o);
            if (removed && o instanceof byte[]) {
                byte[] bytes = (byte[])o;
                this.currentSize -= (long)bytes.length;
            }
            return removed;
        }

        @Override
        public void clear() {
            super.clear();
            this.currentSize = 0L;
        }

        @Override
        public byte[] removeFirst() {
            byte[] removed = (byte[])super.removeFirst();
            this.currentSize -= (long)removed.length;
            return removed;
        }
    }
}

