/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.lookup.db;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.graylog2.database.MongoCollections;
import org.graylog2.database.PaginatedList;
import org.graylog2.database.entities.EntityScopeService;
import org.graylog2.database.pagination.MongoPaginationHelper;
import org.graylog2.database.utils.MongoUtils;
import org.graylog2.database.utils.ScopedEntityMongoUtils;
import org.graylog2.events.ClusterEventBus;
import org.graylog2.lookup.dto.LookupTableDto;
import org.graylog2.lookup.events.LookupTablesDeleted;
import org.graylog2.lookup.events.LookupTablesUpdated;

public class DBLookupTableService {
    public static final String COLLECTION_NAME = "lut_tables";
    private final ClusterEventBus clusterEventBus;
    private final MongoCollection<LookupTableDto> collection;
    private final MongoUtils<LookupTableDto> mongoUtils;
    private final ScopedEntityMongoUtils<LookupTableDto> scopedEntityMongoUtils;
    private final MongoPaginationHelper<LookupTableDto> paginationHelper;

    @Inject
    public DBLookupTableService(MongoCollections mongoCollections, EntityScopeService entityScopeService, ClusterEventBus clusterEventBus) {
        this.clusterEventBus = clusterEventBus;
        this.collection = mongoCollections.collection(COLLECTION_NAME, LookupTableDto.class);
        this.mongoUtils = mongoCollections.utils(this.collection);
        this.scopedEntityMongoUtils = mongoCollections.scopedEntityUtils(this.collection, entityScopeService);
        this.paginationHelper = mongoCollections.paginationHelper(this.collection);
        this.collection.createIndex(Indexes.ascending((String[])new String[]{"name"}), new IndexOptions().unique(true));
    }

    public Optional<LookupTableDto> get(String idOrName) {
        if (ObjectId.isValid((String)idOrName)) {
            return this.mongoUtils.getById(idOrName);
        }
        return Optional.ofNullable((LookupTableDto)this.collection.find(Filters.eq((String)"name", (Object)idOrName)).first());
    }

    public LookupTableDto save(LookupTableDto table) {
        LookupTableDto savedLookupTable;
        if (table.id() == null) {
            String id = this.scopedEntityMongoUtils.create(table);
            savedLookupTable = ((LookupTableDto.Builder)table.toBuilder().id(id)).build();
        } else {
            savedLookupTable = this.scopedEntityMongoUtils.update(table);
        }
        return savedLookupTable;
    }

    public LookupTableDto saveAndPostEvent(LookupTableDto table) {
        LookupTableDto savedLookupTable = this.save(table);
        this.clusterEventBus.post(LookupTablesUpdated.create(savedLookupTable));
        return savedLookupTable;
    }

    public void postBulkUpdate(Collection<LookupTableDto> tables) {
        this.clusterEventBus.post(LookupTablesUpdated.create(tables));
    }

    public Collection<LookupTableDto> findAll() {
        return MongoUtils.stream(this.collection.find()).toList();
    }

    public PaginatedList<LookupTableDto> findPaginated(Bson query, Bson sort, int page, int perPage) {
        return this.paginationHelper.filter(query).sort(sort).perPage(perPage).page(page);
    }

    public Collection<LookupTableDto> findByCacheIds(Collection<String> cacheIds) {
        Bson query = Filters.in((String)"cache", (Iterable)cacheIds.stream().map(ObjectId::new).collect(Collectors.toList()));
        return MongoUtils.stream(this.collection.find(query)).toList();
    }

    public Collection<LookupTableDto> findByDataAdapterIds(Collection<String> dataAdapterIds) {
        Bson query = Filters.in((String)"data_adapter", (Iterable)dataAdapterIds.stream().map(ObjectId::new).collect(Collectors.toList()));
        return MongoUtils.stream(this.collection.find(query)).toList();
    }

    public void deleteAndPostEvent(String idOrName) {
        Optional<LookupTableDto> lookupTableDto = this.get(idOrName);
        lookupTableDto.ifPresent(lookupTable -> {
            this.scopedEntityMongoUtils.deleteById(lookupTable.id());
            this.clusterEventBus.post(LookupTablesDeleted.create(lookupTable));
        });
    }

    public void deleteAndPostEventImmutable(String idOrName) {
        Optional<LookupTableDto> lookupTableDto = this.get(idOrName);
        lookupTableDto.ifPresent(lookupTable -> {
            this.scopedEntityMongoUtils.forceDelete(lookupTable.id());
            this.clusterEventBus.post(LookupTablesDeleted.create(lookupTable));
        });
    }

    public void forEach(Consumer<? super LookupTableDto> action) {
        MongoUtils.stream(this.collection.find()).forEach(action);
    }
}

