/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations;

import jakarta.inject.Inject;
import java.time.ZonedDateTime;
import java.util.HashSet;
import org.graylog2.database.MongoConnection;
import org.graylog2.migrations.Migration;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20230220095500_MigrateStartPageObjectReferencesToGRNbyRemoval
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20230220095500_MigrateStartPageObjectReferencesToGRNbyRemoval.class);
    private final MongoConnection mongoConnection;
    private final ClusterConfigService clusterConfigService;

    @Inject
    public V20230220095500_MigrateStartPageObjectReferencesToGRNbyRemoval(MongoConnection mongoConnection, ClusterConfigService clusterConfigService) {
        this.clusterConfigService = clusterConfigService;
        this.mongoConnection = mongoConnection;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2023-02-20T09:55:00Z");
    }

    @Override
    public void upgrade() {
        if (this.clusterConfigService.get(MigrationCompleted.class) != null) {
            return;
        }
        HashSet names = new HashSet();
        this.mongoConnection.getMongoDatabase().listCollectionNames().forEach(names::add);
        if (names.contains("favorites")) {
            this.mongoConnection.getMongoDatabase().getCollection("favorites").drop();
        }
        if (names.contains("last_opened")) {
            this.mongoConnection.getMongoDatabase().getCollection("last_opened").drop();
        }
        if (names.contains("recent_activity")) {
            this.mongoConnection.getMongoDatabase().getCollection("recent_activity").drop();
        }
        this.clusterConfigService.write(new MigrationCompleted());
    }

    public record MigrationCompleted() {
    }
}

