/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations;

import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import jakarta.inject.Inject;
import java.time.ZonedDateTime;
import java.util.Optional;
import org.bson.Document;
import org.graylog2.cluster.certificates.EncryptedCaKeystore;
import org.graylog2.database.MongoConnection;
import org.graylog2.migrations.Migration;
import org.graylog2.migrations.MigrationType;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.security.encryption.EncryptedValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V202406260800_MigrateCertificateAuthority
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V202406260800_MigrateCertificateAuthority.class);
    public static final String LEGACY_COLLECTION_NAME = "graylog_ca_certificates";
    private final ClusterConfigService clusterConfigService;
    private final MongoConnection mongoConnection;

    @Inject
    public V202406260800_MigrateCertificateAuthority(ClusterConfigService clusterConfigService, MongoConnection mongoConnection) {
        this.clusterConfigService = clusterConfigService;
        this.mongoConnection = mongoConnection;
    }

    @Override
    public MigrationType migrationType() {
        return MigrationType.PREFLIGHT;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2024-06-26T08:00:00Z");
    }

    @Override
    public void upgrade() {
        if (this.clusterConfigService.get(MigrationCompleted.class) != null) {
            LOG.debug("Migration already completed.");
            return;
        }
        this.readExistingKeystore().ifPresent(keystore -> this.clusterConfigService.write(new EncryptedCaKeystore((EncryptedValue)keystore)));
        this.mongoConnection.getMongoDatabase().getCollection(LEGACY_COLLECTION_NAME).drop();
    }

    public Optional<EncryptedValue> readExistingKeystore() {
        Document encryptedCertificateDocument;
        MongoCollection dbCollection = this.mongoConnection.getMongoDatabase().getCollection(LEGACY_COLLECTION_NAME);
        FindIterable objects = dbCollection.find(Filters.eq((String)"node_id", (Object)"GRAYLOG CA"));
        Document caKeystore = (Document)objects.first();
        if (caKeystore != null && (encryptedCertificateDocument = (Document)caKeystore.get((Object)"encrypted_certificate_keystore", Document.class)) != null) {
            EncryptedValue encryptedKeystore = EncryptedValue.builder().value(encryptedCertificateDocument.getString((Object)"encrypted_value")).salt(encryptedCertificateDocument.getString((Object)"salt")).isDeleteValue(false).isKeepValue(false).build();
            return Optional.ofNullable(encryptedKeystore);
        }
        return Optional.empty();
    }

    public record MigrationCompleted() {
    }
}

