/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.outputs;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.github.joschi.jadconfig.ParameterException;
import com.github.joschi.jadconfig.ValidationException;
import com.github.joschi.jadconfig.util.Size;
import com.github.joschi.jadconfig.validators.PositiveIntegerValidator;
import java.util.Objects;
import java.util.Optional;
import org.graylog2.shared.utilities.StringUtils;

public class BatchSizeConfig {
    private final String value;
    private final Size size;
    private final Integer count;

    @JsonCreator
    public static BatchSizeConfig parse(String value) {
        try {
            return new BatchSizeConfig(value, Size.parse((String)value), null);
        }
        catch (IllegalArgumentException sizeParsingException) {
            try {
                return new BatchSizeConfig(value, null, Integer.valueOf(value));
            }
            catch (NumberFormatException ignored) {
                throw new IllegalArgumentException(StringUtils.f("\"%s\" is neither a size [%s] nor an integer.", value, sizeParsingException.getLocalizedMessage()));
            }
        }
    }

    @JsonCreator
    public static BatchSizeConfig forCount(int count) {
        return new BatchSizeConfig(String.valueOf(count), null, count);
    }

    private BatchSizeConfig(String value, Size size, Integer count) {
        this.value = value;
        this.size = size;
        this.count = count;
    }

    public Optional<Size> getAsBytes() {
        return Optional.ofNullable(this.size);
    }

    public Optional<Integer> getAsCount() {
        return Optional.ofNullable(this.count);
    }

    @JsonValue
    public Object jsonValue() {
        if (this.getAsCount().isPresent()) {
            return this.getAsCount();
        }
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BatchSizeConfig)) {
            return false;
        }
        BatchSizeConfig that = (BatchSizeConfig)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    public static class Converter
    implements com.github.joschi.jadconfig.Converter<BatchSizeConfig> {
        public BatchSizeConfig convertFrom(String value) {
            try {
                return BatchSizeConfig.parse(value);
            }
            catch (IllegalArgumentException e) {
                throw new ParameterException(StringUtils.f("Couldn't convert value \"%s\" to batch size config.", value), (Throwable)e);
            }
        }

        public String convertTo(BatchSizeConfig value) {
            return value.value;
        }
    }

    public static class Validator
    implements com.github.joschi.jadconfig.Validator<BatchSizeConfig> {
        public void validate(String name, BatchSizeConfig config) throws ValidationException {
            if (config.size != null && config.size.toMegabytes() > 99L) {
                throw new ValidationException("Parameter <%s> must not be greater than 99 MB. (Found <%s>)".formatted(name, config.size));
            }
            if (config.count != null) {
                new PositiveIntegerValidator().validate(name, config.count);
            }
        }
    }
}

