/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.outputs.filter;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Objects;
import java.util.Set;
import org.graylog2.indexer.messages.ImmutableMessage;
import org.graylog2.outputs.filter.FilteredMessage;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.streams.Stream;

public record DefaultFilteredMessage(ImmutableMessage message, Multimap<String, Stream> destinations) implements FilteredMessage
{
    public DefaultFilteredMessage {
        Objects.requireNonNull(message, "message cannot be null");
        Objects.requireNonNull(destinations, "destinations cannot be null");
    }

    public static DefaultFilteredMessage forDestinationKeys(Message message, Set<String> destinationKeys) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        destinationKeys.forEach(key -> builder.putAll(key, message.getStreams()));
        return new DefaultFilteredMessage(ImmutableMessage.wrap(message), (Multimap<String, Stream>)builder.build());
    }

    @Override
    public boolean isIndexed() {
        return !this.destinations.get((Object)"indexer").isEmpty();
    }
}

