/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.outputs.filter;

import com.codahale.metrics.MetricRegistry;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Sets;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.graylog.plugins.pipelineprocessor.ast.Pipeline;
import org.graylog.plugins.pipelineprocessor.ast.Stage;
import org.graylog.plugins.pipelineprocessor.db.PipelineDao;
import org.graylog.plugins.pipelineprocessor.db.RuleDao;
import org.graylog.plugins.pipelineprocessor.parser.PipelineRuleParser;
import org.graylog.plugins.pipelineprocessor.processors.PipelineMetricRegistry;
import org.graylog.plugins.pipelineprocessor.processors.PipelineResolver;
import org.graylog.plugins.pipelineprocessor.processors.PipelineResolverConfig;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilder;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderStep;
import org.graylog.plugins.pipelineprocessor.rulebuilder.parser.RuleBuilderService;
import org.graylog2.outputs.filter.PipelineRuleOutputFilter;
import org.graylog2.outputs.filter.PipelineRuleOutputFilterState;
import org.graylog2.plugin.outputs.FilteredMessageOutput;
import org.graylog2.shared.utilities.StringUtils;
import org.graylog2.streams.filters.StreamDestinationFilterRuleDTO;
import org.graylog2.streams.filters.StreamDestinationFilterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PipelineRuleOutputFilterStateUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(PipelineRuleOutputFilterStateUpdater.class);
    private final StreamDestinationFilterService filterService;
    private final PipelineRuleOutputFilterState.Factory stateFactory;
    private final Map<String, FilteredMessageOutput> filteredOutputs;
    private final RuleBuilderService ruleBuilderService;
    private final PipelineResolver.Factory resolverFactory;
    private final PipelineRuleParser pipelineRuleParser;
    private final PipelineMetricRegistry pipelineMetricRegistry;

    @Inject
    public PipelineRuleOutputFilterStateUpdater(StreamDestinationFilterService filterService, PipelineRuleOutputFilterState.Factory stateFactory, Map<String, FilteredMessageOutput> filteredOutputs, RuleBuilderService ruleBuilderService, PipelineResolver.Factory resolverFactory, PipelineRuleParser pipelineRuleParser, MetricRegistry metricRegistry) {
        this.filterService = filterService;
        this.stateFactory = stateFactory;
        this.filteredOutputs = filteredOutputs;
        this.ruleBuilderService = ruleBuilderService;
        this.resolverFactory = resolverFactory;
        this.pipelineRuleParser = pipelineRuleParser;
        this.pipelineMetricRegistry = PipelineMetricRegistry.create(metricRegistry, MetricRegistry.name(PipelineRuleOutputFilter.class, (String[])new String[]{"pipelines"}), MetricRegistry.name(PipelineRuleOutputFilter.class, (String[])new String[]{"rules"}));
    }

    public void init(AtomicReference<PipelineRuleOutputFilterState> activeState) {
        this.reload(activeState, ReloadTrigger.empty());
    }

    public void reloadForUpdate(AtomicReference<PipelineRuleOutputFilterState> activeState, Set<String> updatedFilterRuleIds) {
        this.reload(activeState, ReloadTrigger.updatedIds(updatedFilterRuleIds));
    }

    public void reloadForDelete(AtomicReference<PipelineRuleOutputFilterState> activeState, Set<String> deletedFilterRuleIds) {
        this.reload(activeState, ReloadTrigger.deletedIds(deletedFilterRuleIds));
    }

    private synchronized void reload(AtomicReference<PipelineRuleOutputFilterState> activeState, ReloadTrigger reloadTrigger) {
        LOG.debug("Reloading filter rules: {}", (Object)reloadTrigger);
        HashMap streamPipelines = new HashMap();
        ArrayList allRules = new ArrayList();
        HashSet activeStreams = new HashSet();
        Set<String> previouslyActiveStreams = this.getPreviouslyActiveStreams(activeState);
        this.filterService.forEachEnabledFilterGroupedByStream(streamGroup -> {
            LOG.debug("Processing stream group: {}", streamGroup);
            String streamId = streamGroup.streamId();
            List<RuleDao> ruleList = streamGroup.filters().stream().map(this::streamDestinationFilterToRuleDao).toList();
            Pipeline filterPipeline = Pipeline.builder().id(streamId).name("Stream Destination Filter: " + streamId).stages((SortedSet<Stage>)ImmutableSortedSet.of((Comparable)Stage.builder().stage(0).match(Stage.Match.EITHER).ruleReferences(ruleList.stream().map(RuleDao::title).toList()).build())).build();
            streamPipelines.put(streamId, filterPipeline);
            allRules.addAll(ruleList);
            activeStreams.add(streamId);
        });
        LOG.debug("Stream pipelines: {}", streamPipelines);
        LOG.debug("Rule list: {}", allRules);
        LOG.debug("Active streams: {}", activeStreams);
        PipelineResolver resolver = this.resolverFactory.create(PipelineResolverConfig.of(allRules::stream, () -> Stream.of(new PipelineDao[0])), this.pipelineRuleParser);
        activeState.set(this.stateFactory.newState(resolver.resolveFunctions(streamPipelines.values(), this.pipelineMetricRegistry), (ImmutableSet<String>)ImmutableSet.copyOf(this.filteredOutputs.keySet()), (ImmutableSet<String>)ImmutableSet.copyOf(activeStreams)));
        reloadTrigger.deletedIds().forEach(ruleId -> {
            LOG.debug("Removing rule metrics for: {}", ruleId);
            this.pipelineMetricRegistry.removeRuleMetrics((String)ruleId);
        });
        Sets.difference(previouslyActiveStreams, activeStreams).forEach(pipelineId -> {
            LOG.debug("Removing pipeline metrics for: {}", pipelineId);
            this.pipelineMetricRegistry.removePipelineMetrics((String)pipelineId);
        });
    }

    private RuleDao streamDestinationFilterToRuleDao(StreamDestinationFilterRuleDTO dto) {
        RuleBuilderStep removalAction = RuleBuilderStep.builder().id(UUID.randomUUID().toString()).title(UUID.randomUUID().toString()).function("__remove_from_stream_destination__").parameters(Map.of("stream_id", dto.streamId(), "destination_type", dto.destinationType())).build();
        RuleBuilder ruleWithRemovalAction = dto.rule().toBuilder().actions(List.of(removalAction)).build();
        String title = StringUtils.f("[%s] %s", dto.id(), dto.title());
        return RuleDao.builder().id(dto.id()).title(title).source(this.ruleBuilderService.generateRuleSource(title, ruleWithRemovalAction, false)).build();
    }

    private Set<String> getPreviouslyActiveStreams(AtomicReference<PipelineRuleOutputFilterState> activeState) {
        return activeState.get() != null ? activeState.get().getActiveStreams() : Set.of();
    }

    private record ReloadTrigger(Set<String> updatedIds, Set<String> deletedIds) {
        public static ReloadTrigger empty() {
            return new ReloadTrigger(Set.of(), Set.of());
        }

        public static ReloadTrigger updatedIds(Set<String> updatedIds) {
            return new ReloadTrigger(updatedIds, Set.of());
        }

        public static ReloadTrigger deletedIds(Set<String> deletedIds) {
            return new ReloadTrigger(Set.of(), deletedIds);
        }
    }
}

