/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.outputs.filter.functions;

import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.time.Duration;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.functions.messages.StreamCacheService;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderFunctionGroup;
import org.graylog2.outputs.filter.PipelineRuleOutputFilter;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.plugin.utilities.ratelimitedlog.RateLimitedLogFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveFromStreamDestination
extends AbstractFunction<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(RemoveFromStreamDestination.class);
    private static final Logger RATE_LIMITED_LOG = RateLimitedLogFactory.createRateLimitedLog(LOG, 1, Duration.ofSeconds(15L));
    public static final String NAME = "__remove_from_stream_destination__";
    public static final String STREAM_ID_PARAM = "stream_id";
    public static final String DESTINATION_TYPE_PARAM = "destination_type";
    private final ParameterDescriptor<Message, Message> messageParam;
    private final ParameterDescriptor<String, String> streamIdParam;
    private final ParameterDescriptor<String, String> destinationTypeParam;
    private final StreamCacheService streamCacheService;

    @Inject
    public RemoveFromStreamDestination(StreamCacheService streamCacheService) {
        this.streamCacheService = streamCacheService;
        this.messageParam = ParameterDescriptor.type("message", Message.class).optional().description("The message to use, defaults to '$message'.").build();
        this.streamIdParam = ParameterDescriptor.string(STREAM_ID_PARAM).optional().description("The stream to remove the message from.").build();
        this.destinationTypeParam = ParameterDescriptor.string(DESTINATION_TYPE_PARAM).optional().description("The destination type to remove the message from.").build();
    }

    @Override
    public Void evaluate(FunctionArgs args, EvaluationContext context) {
        String streamId = this.streamIdParam.required(args, context);
        String destinationType = this.destinationTypeParam.required(args, context);
        Message message = this.messageParam.optional(args, context).orElse(context.currentMessage());
        Object object = message.getMetadataValue(PipelineRuleOutputFilter.METADATA_KEY);
        if (object instanceof PipelineRuleOutputFilter.Metadata) {
            PipelineRuleOutputFilter.Metadata metadata = (PipelineRuleOutputFilter.Metadata)object;
            Stream stream = this.streamCacheService.getById(streamId);
            if (stream != null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Removing stream <{}/{}> from destination <{}> for message: {}", new Object[]{stream.getId(), stream.getTitle(), destinationType, message});
                }
                metadata.destinations().remove((Object)destinationType, (Object)stream);
            } else {
                RATE_LIMITED_LOG.warn("Couldn't find stream for stream ID <{}> in cache", (Object)streamId);
            }
        }
        return null;
    }

    @Override
    public FunctionDescriptor<Void> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(Void.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.streamIdParam, this.destinationTypeParam, this.messageParam)).description("[INTERNAL] Removes a message from a stream target.").ruleBuilderEnabled().ruleBuilderName(NAME).ruleBuilderTitle("[INTERNAL] Removes a message from a stream target.").ruleBuilderFunctionGroup(RuleBuilderFunctionGroup.OTHER).build();
    }
}

