/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.certificates;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.NotNull;
import java.time.Duration;
import java.time.Period;
import java.time.format.DateTimeParseException;
import java.util.Locale;

public record RenewalPolicy(@JsonProperty(value="mode") @NotNull Mode mode, @JsonProperty(value="certificate_lifetime") @NotNull String certificateLifetime) {
    private static final long CERT_RENEWAL_THRESHOLD_PERCENTAGE = 10L;

    @NotNull
    public Duration parsedCertificateLifetime() {
        return this.safeParse(this.certificateLifetime);
    }

    @JsonIgnore
    public Duration getRenewalThreshold() {
        return this.safeParse(this.certificateLifetime).dividedBy(10L);
    }

    private Duration safeParse(String duration) {
        try {
            return Duration.parse(duration);
        }
        catch (DateTimeParseException ignored) {
            return this.periodToDuration(Period.parse(duration));
        }
    }

    private Duration periodToDuration(Period period) {
        return Duration.ofDays((long)period.getYears() * 365L + (long)period.getMonths() * 30L + (long)period.getDays());
    }

    public static enum Mode {
        AUTOMATIC,
        MANUAL;


        @JsonCreator
        public static Mode create(String value) {
            return Mode.valueOf(value.toUpperCase(Locale.ROOT));
        }
    }
}

