/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.indexer.searches.timeranges;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.auto.value.AutoValue;
import org.graylog2.plugin.indexer.searches.timeranges.AutoValue_KeywordRange;
import org.graylog2.plugin.indexer.searches.timeranges.InvalidRangeParametersException;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.graylog2.plugin.utilities.date.NaturalDateParser;
import org.joda.time.DateTime;

@JsonTypeName(value="keyword")
@AutoValue
public abstract class KeywordRange
extends TimeRange {
    public static final String KEYWORD = "keyword";

    @Override
    @JsonProperty
    public String type() {
        return KEYWORD;
    }

    @JsonProperty
    public abstract String keyword();

    @JsonProperty
    public abstract String timezone();

    private static NaturalDateParser.Result parseResult(String timezone, String keyword) throws InvalidRangeParametersException {
        try {
            return new NaturalDateParser(timezone).parse(keyword);
        }
        catch (NaturalDateParser.DateNotParsableException e) {
            throw new InvalidRangeParametersException("Could not parse from natural date: " + keyword);
        }
    }

    @JsonCreator
    public static KeywordRange create(@JsonProperty(value="keyword") String keyword, @JsonProperty(value="timezone") String timezone) throws InvalidRangeParametersException {
        if (timezone == null) {
            timezone = "Etc/UTC";
        }
        return KeywordRange.builder().timezone(timezone).keyword(keyword).build();
    }

    private static Builder builder() {
        return new AutoValue_KeywordRange.Builder();
    }

    public String getKeyword() {
        return this.keyword();
    }

    @Override
    @JsonIgnore
    public DateTime getFrom() {
        try {
            return KeywordRange.parseResult(this.timezone(), this.keyword()).getFrom();
        }
        catch (InvalidRangeParametersException e) {
            return null;
        }
    }

    @Override
    @JsonIgnore
    public DateTime getTo() {
        try {
            return KeywordRange.parseResult(this.timezone(), this.keyword()).getTo();
        }
        catch (InvalidRangeParametersException e) {
            return null;
        }
    }

    @Override
    public TimeRange withReferenceDate(DateTime now) {
        return this;
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder keyword(String var1);

        public abstract Builder timezone(String var1);

        abstract String keyword();

        abstract String timezone();

        abstract KeywordRange autoBuild();

        public KeywordRange build() throws InvalidRangeParametersException {
            KeywordRange.parseResult(this.timezone(), this.keyword());
            return this.autoBuild();
        }
    }
}

