/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.lookup;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.inject.assistedinject.Assisted;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.graylog2.plugin.lookup.LookupCacheConfiguration;
import org.graylog2.plugin.lookup.LookupCacheKey;
import org.graylog2.plugin.lookup.LookupResult;
import org.graylog2.shared.metrics.MetricUtils;
import org.graylog2.utilities.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LookupCache
extends AbstractIdleService {
    private static final Logger LOG = LoggerFactory.getLogger(LookupCache.class);
    private String id;
    private final String name;
    private final LookupCacheConfiguration config;
    private final Meter totalCount;
    private final Meter hitCount;
    private final Meter missCount;
    private final Timer lookupTimer;
    private AtomicReference<Throwable> error = new AtomicReference();

    protected LookupCache(String id, String name, LookupCacheConfiguration config, MetricRegistry metricRegistry) {
        this.id = id;
        this.name = name;
        this.config = config;
        this.totalCount = metricRegistry.meter(MetricRegistry.name((String)"org.graylog2.lookup.caches", (String[])new String[]{id, "requests"}));
        this.hitCount = metricRegistry.meter(MetricRegistry.name((String)"org.graylog2.lookup.caches", (String[])new String[]{id, "hits"}));
        this.missCount = metricRegistry.meter(MetricRegistry.name((String)"org.graylog2.lookup.caches", (String[])new String[]{id, "misses"}));
        this.lookupTimer = metricRegistry.timer(MetricRegistry.name((String)"org.graylog2.lookup.caches", (String[])new String[]{id, "lookupTime"}));
        Gauge entriesGauge = this::entryCount;
        MetricUtils.reRegister(metricRegistry, MetricRegistry.name((String)"org.graylog2.lookup.caches", (String[])new String[]{id, "entries"}), entriesGauge);
    }

    @Deprecated
    public void incrTotalCount() {
        this.totalCount.mark();
    }

    public void incrTotalCount(long n) {
        this.totalCount.mark(n);
    }

    @Deprecated
    public void incrHitCount() {
        this.hitCount.mark();
    }

    public void incrHitCount(long n) {
        this.hitCount.mark(n);
    }

    @Deprecated
    public void incrMissCount() {
        this.missCount.mark();
    }

    public void incrMissCount(long n) {
        this.missCount.mark(n);
    }

    public Timer.Context lookupTimer() {
        return this.lookupTimer.time();
    }

    public long entryCount() {
        return -1L;
    }

    protected void startUp() throws Exception {
        try {
            this.doStart();
        }
        catch (Exception e) {
            LOG.error("Couldn't start cache <{}/{}/@{}>", new Object[]{this.name(), this.id(), ObjectUtils.objectId((Object)this), e});
            this.setError(e);
        }
    }

    protected abstract void doStart() throws Exception;

    protected void shutDown() throws Exception {
        try {
            this.doStop();
        }
        catch (Exception e) {
            LOG.error("Couldn't stop cache <{}/{}/@{}>", new Object[]{this.name(), this.id(), ObjectUtils.objectId((Object)this), e});
        }
    }

    protected abstract void doStop() throws Exception;

    protected void clearError() {
        this.error.set(null);
    }

    public Optional<Throwable> getError() {
        return Optional.ofNullable(this.error.get());
    }

    protected void setError(Throwable throwable) {
        this.error.set(throwable);
    }

    @Nullable
    public String id() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public abstract LookupResult get(LookupCacheKey var1, Callable<LookupResult> var2);

    public abstract LookupResult getIfPresent(LookupCacheKey var1);

    public abstract void purge();

    public abstract void purge(LookupCacheKey var1);

    public LookupCacheConfiguration getConfig() {
        return this.config;
    }

    public String name() {
        return this.name;
    }

    public static abstract class Descriptor<C extends LookupCacheConfiguration> {
        private final String type;
        private final Class<C> configClass;

        public Descriptor(String type, Class<C> configClass) {
            this.type = type;
            this.configClass = configClass;
        }

        @JsonProperty(value="type")
        public String getType() {
            return this.type;
        }

        @JsonProperty(value="config_class")
        public Class<C> getConfigClass() {
            return this.configClass;
        }

        @JsonProperty(value="default_config")
        public abstract C defaultConfiguration();
    }

    public static interface Factory<T extends LookupCache> {
        public T create(@Assisted(value="id") String var1, @Assisted(value="name") String var2, LookupCacheConfiguration var3);

        public Descriptor getDescriptor();
    }
}

