/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.lookup;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.graylog2.lookup.LookupDefaultMultiValue;
import org.graylog2.lookup.LookupDefaultSingleValue;
import org.graylog2.plugin.lookup.AutoValue_LookupResult;

@AutoValue
public abstract class LookupResult {
    private static final long NO_TTL = Long.MAX_VALUE;
    private static final long ERROR_CACHE_TTL = Duration.ofSeconds(5L).toMillis();
    public static final LookupResult EMPTY_LOOKUP_RESULT = LookupResult.builder().cacheTTL(Long.MAX_VALUE).build();
    public static final LookupResult DEFAULT_ERROR_LOOKUP_RESULT = LookupResult.builder().cacheTTL(ERROR_CACHE_TTL).hasError(true).build();
    public static final String SINGLE_VALUE_KEY = "value";

    @JsonProperty(value="single_value")
    @Nullable
    public abstract Object singleValue();

    @JsonProperty(value="multi_value")
    @Nullable
    public abstract Map<Object, Object> multiValue();

    @JsonProperty(value="string_list_value")
    @Nullable
    public abstract List<String> stringListValue();

    @JsonProperty(value="has_error")
    public abstract boolean hasError();

    @JsonProperty(value="ttl")
    public abstract long cacheTTL();

    @JsonIgnore
    public boolean isEmpty() {
        return this.singleValue() == null && this.multiValue() == null && this.stringListValue() == null;
    }

    @JsonIgnore
    public boolean hasTTL() {
        return this.cacheTTL() != Long.MAX_VALUE;
    }

    public static LookupResult empty() {
        return EMPTY_LOOKUP_RESULT;
    }

    public static LookupResult withError() {
        return DEFAULT_ERROR_LOOKUP_RESULT;
    }

    public static LookupResult withError(String errorMsg) {
        return LookupResult.builder().cacheTTL(ERROR_CACHE_TTL).hasError(true).singleValue(errorMsg).build();
    }

    public static LookupResult withError(long errorTTL) {
        return LookupResult.builder().hasError(true).cacheTTL(errorTTL).build();
    }

    public static LookupResult single(CharSequence singleValue) {
        return LookupResult.multi(singleValue, Collections.singletonMap(SINGLE_VALUE_KEY, singleValue));
    }

    public static LookupResult single(Number singleValue) {
        return LookupResult.multi(singleValue, Collections.singletonMap(SINGLE_VALUE_KEY, singleValue));
    }

    public static LookupResult single(Boolean singleValue) {
        return LookupResult.multi(singleValue, Collections.singletonMap(SINGLE_VALUE_KEY, singleValue));
    }

    public static LookupResult multi(CharSequence singleValue, Map<Object, Object> multiValue) {
        return LookupResult.withoutTTL().single(singleValue).multiValue(multiValue).build();
    }

    public static LookupResult multi(Number singleValue, Map<Object, Object> multiValue) {
        return LookupResult.withoutTTL().single(singleValue).multiValue(multiValue).build();
    }

    public static LookupResult multi(Boolean singleValue, Map<Object, Object> multiValue) {
        return LookupResult.withoutTTL().single(singleValue).multiValue(multiValue).build();
    }

    public static LookupResult withDefaults(LookupDefaultSingleValue singleValue, LookupDefaultMultiValue multiValue) {
        return LookupResult.addDefaults(singleValue, multiValue).build();
    }

    public static Builder addDefaults(LookupDefaultSingleValue singleValue, LookupDefaultMultiValue multiValue) {
        Builder builder = LookupResult.withoutTTL();
        switch (singleValue.valueType()) {
            case STRING: {
                builder = builder.single((CharSequence)singleValue.value());
                break;
            }
            case NUMBER: {
                builder = builder.single((Number)singleValue.value());
                break;
            }
            case BOOLEAN: {
                builder = builder.single((Boolean)singleValue.value());
                break;
            }
            case OBJECT: {
                throw new IllegalArgumentException("Single value cannot be of type OBJECT");
            }
        }
        if (multiValue.isSet()) {
            builder = builder.multiValue((Map<Object, Object>)multiValue.value());
        } else if (singleValue.isSet()) {
            builder = builder.multiValue(Collections.singletonMap(SINGLE_VALUE_KEY, singleValue.value()));
        }
        return builder;
    }

    @JsonCreator
    public static LookupResult createFromJSON(@JsonProperty(value="single_value") Object singleValue, @JsonProperty(value="multi_value") Map<Object, Object> multiValue, @JsonProperty(value="string_list_value") List<String> stringListValue, @JsonProperty(value="has_error") boolean hasError, @JsonProperty(value="ttl") long cacheTTL) {
        return LookupResult.builder().singleValue(singleValue).multiValue(multiValue).stringListValue(stringListValue).hasError(hasError).cacheTTL(cacheTTL).build();
    }

    public static Builder withoutTTL() {
        return LookupResult.builder().cacheTTL(Long.MAX_VALUE);
    }

    public static Builder builder() {
        return new AutoValue_LookupResult.Builder().hasError(false);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        abstract Builder singleValue(Object var1);

        public abstract Builder multiValue(Map<Object, Object> var1);

        public abstract Builder stringListValue(List<String> var1);

        public abstract Builder cacheTTL(long var1);

        public abstract Builder hasError(boolean var1);

        public Builder single(CharSequence singleValue) {
            return this.singleValue(singleValue);
        }

        public Builder single(Number singleValue) {
            return this.singleValue(singleValue);
        }

        public Builder single(Boolean singleValue) {
            return this.singleValue(singleValue);
        }

        public Builder multiSingleton(Object value) {
            return this.multiValue(Collections.singletonMap(LookupResult.SINGLE_VALUE_KEY, value));
        }

        public abstract LookupResult build();
    }
}

