/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.mongodb.client.model.Sorts;
import jakarta.ws.rs.BadRequestException;
import java.util.List;
import java.util.Locale;
import org.bson.conversions.Bson;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum SortOrder {
    ASCENDING{

        @Override
        public Bson toBsonSort(String ... fields) {
            return Sorts.ascending((String[])fields);
        }

        @Override
        public Bson toBsonSort(List<String> fields) {
            return Sorts.ascending(fields);
        }
    }
    ,
    DESCENDING{

        @Override
        public Bson toBsonSort(String ... fields) {
            return Sorts.descending((String[])fields);
        }

        @Override
        public Bson toBsonSort(List<String> fields) {
            return Sorts.descending(fields);
        }
    };


    @JsonCreator
    public static SortOrder fromString(String order) {
        return switch (order.toLowerCase(Locale.ENGLISH)) {
            case "asc" -> ASCENDING;
            case "desc" -> DESCENDING;
            default -> throw new BadRequestException("Unknown sort order: " + order);
        };
    }

    public abstract Bson toBsonSort(String ... var1);

    public abstract Bson toBsonSort(List<String> var1);
}

