/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.cluster;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotEmpty;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import okhttp3.ResponseBody;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.cluster.Node;
import org.graylog2.cluster.NodeNotFoundException;
import org.graylog2.cluster.NodeService;
import org.graylog2.rest.RemoteInterfaceProvider;
import org.graylog2.rest.RestTools;
import org.graylog2.rest.models.system.loggers.responses.LoggersSummary;
import org.graylog2.rest.models.system.loggers.responses.SubsystemSummary;
import org.graylog2.rest.resources.system.logs.RemoteLoggersResource;
import org.graylog2.shared.rest.HideOnCloud;
import org.graylog2.shared.rest.resources.ProxiedResource;

@RequiresAuthentication
@Api(value="Cluster/System/Loggers", description="Cluster-wide access to internal Graylog loggers")
@Path(value="/cluster/system/loggers")
public class ClusterLoggersResource
extends ProxiedResource {
    @Inject
    public ClusterLoggersResource(NodeService nodeService, RemoteInterfaceProvider remoteInterfaceProvider, @Context HttpHeaders httpHeaders, @Named(value="proxiedRequestsExecutorService") ExecutorService executorService) throws NodeNotFoundException {
        super(httpHeaders, nodeService, remoteInterfaceProvider, executorService);
    }

    @GET
    @Timed
    @ApiOperation(value="List all loggers of all nodes and their current levels")
    @Produces(value={"application/json"})
    public Map<String, Optional<LoggersSummary>> loggers() {
        return this.stripCallResult(this.requestOnAllNodes(RemoteLoggersResource.class, RemoteLoggersResource::loggers));
    }

    @GET
    @Timed
    @Path(value="/subsystems")
    @ApiOperation(value="List all logger subsystems and their current levels")
    @Produces(value={"application/json"})
    public Map<String, Optional<SubsystemSummary>> subsystems() {
        return this.stripCallResult(this.requestOnAllNodes(RemoteLoggersResource.class, RemoteLoggersResource::subsystems));
    }

    @PUT
    @Timed
    @Path(value="/{nodeId}/subsystems/{subsystem}/level/{level}")
    @ApiOperation(value="Set the loglevel of a whole subsystem", notes="Provided level is falling back to DEBUG if it does not exist")
    @ApiResponses(value={@ApiResponse(code=404, message="No such subsystem.")})
    @NoAuditEvent(value="proxy resource, audit event will be emitted on target nodes")
    public void setSubsystemLoggerLevel(@ApiParam(name="nodeId", required=true) @PathParam(value="nodeId") @NotEmpty String nodeId, @ApiParam(name="subsystem", required=true) @PathParam(value="subsystem") @NotEmpty String subsystemTitle, @ApiParam(name="level", required=true) @PathParam(value="level") @NotEmpty String level) throws NodeNotFoundException, IOException {
        Node node = this.nodeService.byNodeId(nodeId);
        RemoteLoggersResource remoteLoggersResource = this.remoteInterfaceProvider.get(node, this.getAuthenticationToken(), RemoteLoggersResource.class);
        remoteLoggersResource.setSubsystemLoggerLevel(subsystemTitle, level).execute();
    }

    @PUT
    @Timed
    @Path(value="/{loggerName}/level/{level}")
    @ApiOperation(value="Set the loglevel of a single logger", notes="Provided level is falling back to DEBUG if it does not exist")
    @NoAuditEvent(value="proxy resource, audit event will be emitted on target nodes")
    @Produces(value={"application/json"})
    public Map<String, ProxiedResource.CallResult<Void>> setClusterSingleLoggerLevel(@ApiParam(name="loggerName", required=true) @PathParam(value="loggerName") @NotEmpty String loggerName, @ApiParam(name="level", required=true) @PathParam(value="level") @NotEmpty String level) {
        return this.requestOnAllNodes(RemoteLoggersResource.class, client -> client.setSingleLoggerLevel(loggerName, level));
    }

    @GET
    @Path(value="messages/recent/{nodeId}")
    @ApiOperation(value="Get recent internal log messages from a specific node")
    @ApiResponses(value={@ApiResponse(code=404, message="Memory appender is disabled."), @ApiResponse(code=500, message="Memory appender is broken.")})
    @Produces(value={"text/plain"})
    @HideOnCloud
    public Response messages(@ApiParam(name="nodeId", value="The nodeId to get logs from") @PathParam(value="nodeId") @NotEmpty String nodeId, @ApiParam(name="limit", value="How many log messages should be returned. 0 returns all existing messages.The limit can be rounded up to the next batch size and thus return slightly more logs than requested.", defaultValue="1000", allowableValues="range[0, infinity]") @QueryParam(value="limit") @DefaultValue(value="1000") @Min(value=0L) @Min(value=0L) int limit) throws IOException {
        ProxiedResource.NodeResponse<ResponseBody> nodeResponse = this.doNodeApiCall(nodeId, RemoteLoggersResource.class, c -> c.messages(limit), Function.identity(), null);
        return RestTools.streamResponse(nodeResponse, "text/plain", null);
    }
}

