/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.datanodes;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog.security.UserContext;
import org.graylog.security.certutil.CertRenewalService;
import org.graylog2.audit.AuditEventSender;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.cluster.NodeNotFoundException;
import org.graylog2.cluster.nodes.DataNodeDto;
import org.graylog2.cluster.nodes.NodeService;
import org.graylog2.configuration.RunsWithDataNode;
import org.graylog2.datanode.DataNodeCommandService;
import org.graylog2.rest.bulk.AuditParams;
import org.graylog2.rest.bulk.BulkExecutor;
import org.graylog2.rest.bulk.SequentialBulkExecutor;
import org.graylog2.rest.bulk.model.BulkOperationRequest;
import org.graylog2.rest.bulk.model.BulkOperationResponse;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Api(value="Datanode", description="Data Node", tags={"cloud"})
@Path(value="/datanode/")
@Produces(value={"application/json"})
public class DataNodeManagementResource
extends RestResource {
    private final DataNodeCommandService dataNodeCommandService;
    private final NodeService<DataNodeDto> nodeService;
    private final CertRenewalService certRenewalService;
    private final Boolean runsWithDataNode;
    private final BulkExecutor<DataNodeDto, UserContext> bulkRemovalExecutor;
    private final BulkExecutor<DataNodeDto, UserContext> bulkStopExecutor;
    private final BulkExecutor<DataNodeDto, UserContext> bulkStartExecutor;

    @Inject
    protected DataNodeManagementResource(DataNodeCommandService dataNodeCommandService, NodeService<DataNodeDto> nodeService, CertRenewalService certRenewalService, @RunsWithDataNode Boolean runsWithDataNode, AuditEventSender auditEventSender, ObjectMapper objectMapper) {
        this.dataNodeCommandService = dataNodeCommandService;
        this.nodeService = nodeService;
        this.certRenewalService = certRenewalService;
        this.runsWithDataNode = runsWithDataNode;
        this.bulkRemovalExecutor = new SequentialBulkExecutor<DataNodeDto, UserContext>(this::removeNode, auditEventSender, objectMapper);
        this.bulkStopExecutor = new SequentialBulkExecutor<DataNodeDto, UserContext>(this::stopNode, auditEventSender, objectMapper);
        this.bulkStartExecutor = new SequentialBulkExecutor<DataNodeDto, UserContext>(this::startNode, auditEventSender, objectMapper);
    }

    @GET
    @Path(value="configured")
    @ApiOperation(value="Returns whether this Graylog is running against a data node search backend")
    @RequiresPermissions(value={"datanode:read"})
    public Boolean runsWithDataNode() {
        return this.runsWithDataNode;
    }

    @GET
    @Path(value="{nodeId}")
    @ApiOperation(value="Get data node information")
    @RequiresPermissions(value={"datanode:read"})
    public DataNodeDto getDataNode(@ApiParam(name="nodeId", required=true) @PathParam(value="nodeId") String nodeId) {
        try {
            return this.nodeService.byNodeId(nodeId);
        }
        catch (NodeNotFoundException e) {
            throw new NotFoundException("Node " + nodeId + " not found");
        }
    }

    @DELETE
    @Path(value="{nodeId}")
    @ApiOperation(value="Remove node from cluster")
    @AuditEvent(type="server:data_node:remove")
    @RequiresPermissions(value={"datanode:remove"})
    public DataNodeDto removeNode(@ApiParam(name="nodeId", required=true) @PathParam(value="nodeId") String nodeId, @Context UserContext userContext) {
        try {
            return this.dataNodeCommandService.removeNode(nodeId);
        }
        catch (NodeNotFoundException e) {
            throw new NotFoundException("Node " + nodeId + " not found");
        }
    }

    @POST
    @Path(value="/bulk_remove")
    @Consumes(value={"application/json"})
    @Timed
    @ApiOperation(value="Remove multiple nodes from the cluster", response=BulkOperationResponse.class)
    @NoAuditEvent(value="Audit events triggered manually")
    public Response bulkRemove(@ApiParam(name="Entities to remove", required=true) BulkOperationRequest bulkOperationRequest, @Context UserContext userContext) {
        BulkOperationResponse response = this.bulkRemovalExecutor.executeBulkOperation(bulkOperationRequest, userContext, new AuditParams("server:data_node:remove", "nodeId", DataNodeDto.class));
        return Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
    }

    @POST
    @Path(value="{nodeId}/reset")
    @ApiOperation(value="Reset a removed node to rejoin the cluster")
    @AuditEvent(type="server:data_node:reset")
    @RequiresPermissions(value={"datanode:reset"})
    public DataNodeDto resetNode(@ApiParam(name="nodeId", required=true) @PathParam(value="nodeId") String nodeId) {
        try {
            return this.dataNodeCommandService.resetNode(nodeId);
        }
        catch (NodeNotFoundException e) {
            throw new NotFoundException("Node " + nodeId + " not found");
        }
    }

    @POST
    @Path(value="{nodeId}/stop")
    @ApiOperation(value="Stop the OpenSearch process of a data node")
    @AuditEvent(type="server:data_node:stop")
    @RequiresPermissions(value={"datanode:stop"})
    public DataNodeDto stopNode(@ApiParam(name="nodeId", required=true) @PathParam(value="nodeId") String nodeId, @Context UserContext userContext) {
        try {
            return this.dataNodeCommandService.stopNode(nodeId);
        }
        catch (NodeNotFoundException e) {
            throw new NotFoundException("Node " + nodeId + " not found");
        }
    }

    @POST
    @Path(value="/bulk_stop")
    @Consumes(value={"application/json"})
    @Timed
    @ApiOperation(value="Stop multiple nodes in the cluster", response=BulkOperationResponse.class)
    @NoAuditEvent(value="Audit events triggered manually")
    public Response bulkStop(@ApiParam(name="Entities to stop", required=true) BulkOperationRequest bulkOperationRequest, @Context UserContext userContext) {
        BulkOperationResponse response = this.bulkStopExecutor.executeBulkOperation(bulkOperationRequest, userContext, new AuditParams("server:data_node:stop", "nodeId", DataNodeDto.class));
        return Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
    }

    @POST
    @Path(value="{nodeId}/start")
    @ApiOperation(value="Start the OpenSearch process of a data node")
    @AuditEvent(type="server:data_node:start")
    @RequiresPermissions(value={"datanode:start"})
    public DataNodeDto startNode(@ApiParam(name="nodeId", required=true) @PathParam(value="nodeId") String nodeId, @Context UserContext userContext) {
        try {
            return this.dataNodeCommandService.startNode(nodeId);
        }
        catch (NodeNotFoundException e) {
            throw new NotFoundException("Node " + nodeId + " not found");
        }
    }

    @POST
    @Path(value="/bulk_start")
    @Consumes(value={"application/json"})
    @Timed
    @ApiOperation(value="Start multiple nodes in the cluster", response=BulkOperationResponse.class)
    @NoAuditEvent(value="Audit events triggered manually")
    public Response bulkStart(@ApiParam(name="Entities to start", required=true) BulkOperationRequest bulkOperationRequest, @Context UserContext userContext) {
        BulkOperationResponse response = this.bulkStartExecutor.executeBulkOperation(bulkOperationRequest, userContext, new AuditParams("server:data_node:start", "nodeId", DataNodeDto.class));
        return Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
    }
}

