/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.datanodes;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.List;
import java.util.function.Predicate;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.indexer.datanode.ProxyRequestAdapter;
import org.graylog2.rest.resources.datanodes.DatanodeRestApiProxy;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Api(value="DataNodes/REST/API", description="Proxy direct access to Data Node's API")
@Path(value="/datanodes/{hostname}/rest/{path: .*}")
@Produces(value={"application/json"})
@Timed
@RequiresPermissions(value={"datanode:restproxy"})
public class DataNodeRestApiProxyResource
extends RestResource {
    private static final List<Predicate<ProxyRequestAdapter.ProxyRequest>> allowList = List.of(request -> request.path().startsWith("indices-directory") && "GET".equals(request.method()), request -> request.path().startsWith("logs") && "GET".equals(request.method()), request -> request.path().startsWith("connection-check") && "POST".equals(request.method()));
    private final DatanodeRestApiProxy proxyRequestAdapter;
    private final boolean enableAllowlist;

    @Inject
    public DataNodeRestApiProxyResource(DatanodeRestApiProxy proxyRequestAdapter, @Named(value="datanode_proxy_api_allowlist") boolean enableAllowlist) {
        this.proxyRequestAdapter = proxyRequestAdapter;
        this.enableAllowlist = enableAllowlist;
    }

    @GET
    @ApiOperation(value="GET request to Data Node's API")
    @AuditEvent(type="server:data_node:api_request", captureRequestEntity=false, captureResponseEntity=false)
    public Response requestGet(@ApiParam(name="path", required=true) @PathParam(value="path") String path, @ApiParam(name="hostname", required=true) @PathParam(value="hostname") String hostname, @Context ContainerRequestContext requestContext) throws IOException {
        return this.request(requestContext, path, hostname);
    }

    @POST
    @ApiOperation(value="POST request to Data Node's API")
    @AuditEvent(type="server:data_node:api_request", captureRequestEntity=false, captureResponseEntity=false)
    public Response requestPost(@ApiParam(name="path", required=true) @PathParam(value="path") String path, @ApiParam(name="hostname", required=true) @PathParam(value="hostname") String hostname, @Context ContainerRequestContext requestContext) throws IOException {
        return this.request(requestContext, path, hostname);
    }

    @PUT
    @ApiOperation(value="PUT request to Data Node's API")
    @AuditEvent(type="server:data_node:api_request", captureRequestEntity=false, captureResponseEntity=false)
    public Response requestPut(@ApiParam(name="path", required=true) @PathParam(value="path") String path, @ApiParam(name="hostname", required=true) @PathParam(value="hostname") String hostname, @Context ContainerRequestContext requestContext) throws IOException {
        return this.request(requestContext, path, hostname);
    }

    @DELETE
    @ApiOperation(value="DELETE request to Data Node's API")
    @AuditEvent(type="server:data_node:api_request", captureRequestEntity=false, captureResponseEntity=false)
    public Response requestDelete(@ApiParam(name="path", required=true) @PathParam(value="path") String path, @ApiParam(name="hostname", required=true) @PathParam(value="hostname") String hostname, @Context ContainerRequestContext requestContext) throws IOException {
        return this.request(requestContext, path, hostname);
    }

    private Response request(ContainerRequestContext context, String path, String hostname) throws IOException {
        ProxyRequestAdapter.ProxyRequest request = new ProxyRequestAdapter.ProxyRequest(context.getMethod(), path, context.getEntityStream(), hostname, (MultivaluedMap<String, String>)context.getUriInfo().getQueryParameters());
        if (this.enableAllowlist && allowList.stream().noneMatch(condition -> condition.test(request))) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"This request is not allowed.").type(MediaType.TEXT_PLAIN_TYPE).build();
        }
        ProxyRequestAdapter.ProxyResponse response = this.proxyRequestAdapter.request(request);
        return Response.status((int)response.status()).entity((Object)response.response()).type(response.contentType()).build();
    }
}

