/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system;

import com.codahale.metrics.annotation.Timed;
import com.eaio.uuid.UUID;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.inject.Inject;
import jakarta.validation.constraints.NotEmpty;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.ArrayList;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.cluster.Node;
import org.graylog2.cluster.NodeNotFoundException;
import org.graylog2.cluster.NodeService;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.cluster.ClusterId;
import org.graylog2.plugin.system.NodeId;
import org.graylog2.rest.models.system.cluster.responses.NodeSummary;
import org.graylog2.rest.models.system.cluster.responses.NodeSummaryList;
import org.graylog2.shared.rest.resources.RestResource;

@Api(value="System/Cluster", description="Node discovery")
@RequiresAuthentication
@Path(value="/system/cluster")
@Produces(value={"application/json"})
public class ClusterResource
extends RestResource {
    private final NodeService nodeService;
    private final NodeId nodeId;
    private final ClusterId clusterId;

    @Inject
    public ClusterResource(NodeService nodeService, ClusterConfigService clusterConfigService, NodeId nodeId) {
        this.nodeService = nodeService;
        this.nodeId = nodeId;
        this.clusterId = clusterConfigService.getOrDefault(ClusterId.class, ClusterId.create(UUID.nilUUID().toString()));
    }

    @GET
    @Timed
    @Path(value="/nodes")
    @ApiOperation(value="List all active nodes in this cluster.")
    public NodeSummaryList nodes() {
        Map<String, Node> nodes = this.nodeService.allActive();
        ArrayList<NodeSummary> nodeList = new ArrayList<NodeSummary>(nodes.size());
        for (Node node : nodes.values()) {
            nodeList.add(this.nodeSummary(node));
        }
        return NodeSummaryList.create(nodeList);
    }

    @GET
    @Timed
    @Path(value="/node")
    @ApiOperation(value="Information about this node.", notes="This is returning information of this node in context to its state in the cluster. Use the system API of the node itself to get system information.")
    public NodeSummary node() throws NodeNotFoundException {
        return this.nodeSummary(this.nodeService.byNodeId(this.nodeId));
    }

    @GET
    @Timed
    @Path(value="/nodes/{nodeId}")
    @ApiOperation(value="Information about a node.", notes="This is returning information of a node in context to its state in the cluster. Use the system API of the node itself to get system information.")
    @ApiResponses(value={@ApiResponse(code=404, message="Node not found.")})
    public NodeSummary node(@ApiParam(name="nodeId", required=true) @PathParam(value="nodeId") @NotEmpty String nodeId) throws NodeNotFoundException {
        return this.nodeSummary(this.nodeService.byNodeId(nodeId));
    }

    private NodeSummary nodeSummary(Node node) {
        return NodeSummary.create(this.clusterId.clusterId(), node.getNodeId(), node.isLeader(), node.getTransportAddress(), Tools.getISO8601String(node.getLastSeen()), node.getShortNodeId(), node.getHostname());
    }
}

