/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import jakarta.inject.Inject;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.IndexSetRegistry;
import org.graylog2.indexer.indices.TooManyAliasesException;
import org.graylog2.rest.models.system.deflector.responses.DeflectorSummary;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.shared.security.RestrictToLeader;
import org.graylog2.shared.system.activities.Activity;
import org.graylog2.shared.system.activities.ActivityWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="System/Deflector", description="Index deflector management")
@Path(value="/system/deflector")
public class DeflectorResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(DeflectorResource.class);
    private final IndexSetRegistry indexSetRegistry;
    private final ActivityWriter activityWriter;

    @Inject
    public DeflectorResource(IndexSetRegistry indexSetRegistry, ActivityWriter activityWriter) {
        this.indexSetRegistry = indexSetRegistry;
        this.activityWriter = activityWriter;
    }

    @GET
    @Timed
    @ApiOperation(value="Get current deflector status")
    @RequiresPermissions(value={"deflector:read"})
    @Produces(value={"application/json"})
    @Deprecated
    public DeflectorSummary deprecatedDeflector() throws TooManyAliasesException {
        IndexSet indexSet = this.indexSetRegistry.getDefault();
        return DeflectorSummary.create(indexSet.isUp(), indexSet.getActiveWriteIndex());
    }

    @GET
    @Timed
    @Path(value="/{indexSetId}")
    @ApiOperation(value="Get current deflector status in index set")
    @RequiresPermissions(value={"deflector:read"})
    @Produces(value={"application/json"})
    public DeflectorSummary deflector(@ApiParam(name="indexSetId") @PathParam(value="indexSetId") String indexSetId) throws TooManyAliasesException {
        IndexSet indexSet = this.getIndexSet(this.indexSetRegistry, indexSetId);
        return DeflectorSummary.create(indexSet.isUp(), indexSet.getActiveWriteIndex());
    }

    @POST
    @Timed
    @ApiOperation(value="Cycle deflector to new/next index")
    @RequiresPermissions(value={"deflector:cycle"})
    @Path(value="/cycle")
    @RestrictToLeader
    @AuditEvent(type="server:es_write_index_update_job:start")
    @Deprecated
    public void deprecatedCycle() {
        IndexSet indexSet = this.indexSetRegistry.getDefault();
        this.checkCycle(indexSet);
        String msg = "Cycling deflector for default index set <" + indexSet.getConfig().id() + ">. Reason: REST request.";
        LOG.info(msg);
        this.activityWriter.write(new Activity(msg, DeflectorResource.class));
        indexSet.cycle();
    }

    @POST
    @Timed
    @ApiOperation(value="Cycle deflector to new/next index in index set")
    @RequiresPermissions(value={"deflector:cycle"})
    @Path(value="/{indexSetId}/cycle")
    @RestrictToLeader
    @AuditEvent(type="server:es_write_index_update_job:start")
    public void cycle(@ApiParam(name="indexSetId") @PathParam(value="indexSetId") String indexSetId) {
        IndexSet indexSet = this.getIndexSet(this.indexSetRegistry, indexSetId);
        this.checkCycle(indexSet);
        String msg = "Cycling deflector for index set <" + indexSetId + ">. Reason: REST request.";
        LOG.info(msg);
        this.activityWriter.write(new Activity(msg, DeflectorResource.class));
        indexSet.cycle();
    }

    private void checkCycle(IndexSet indexSet) {
        if (!indexSet.getConfig().isWritable()) {
            String id = indexSet.getConfig().id();
            String title = indexSet.getConfig().title();
            throw new BadRequestException("Unable to cycle non-writable index set <" + id + "> (" + title + ")");
        }
    }
}

