/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.contentpacks.titles;

import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import jakarta.inject.Inject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.graylog.plugins.views.search.permissions.EntityPermissions;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.dbcatalog.DbEntitiesCatalog;
import org.graylog2.database.dbcatalog.DbEntityCatalogEntry;
import org.graylog2.rest.resources.system.contentpacks.titles.EntityTitleService;
import org.graylog2.rest.resources.system.contentpacks.titles.model.EntitiesTitleResponse;
import org.graylog2.rest.resources.system.contentpacks.titles.model.EntityIdentifier;
import org.graylog2.rest.resources.system.contentpacks.titles.model.EntityTitleRequest;
import org.graylog2.rest.resources.system.contentpacks.titles.model.EntityTitleResponse;

public class EntityTitleServiceImpl
implements EntityTitleService {
    private final MongoConnection mongoConnection;
    private final DbEntitiesCatalog entitiesCatalog;
    static final String TITLE_IF_NOT_PERMITTED = "";

    @Inject
    public EntityTitleServiceImpl(MongoConnection mongoConnection, DbEntitiesCatalog entitiesCatalog) {
        this.mongoConnection = mongoConnection;
        this.entitiesCatalog = entitiesCatalog;
    }

    @Override
    public EntitiesTitleResponse getTitles(EntityTitleRequest request, EntityPermissions permissions) {
        if (request == null || request.entities() == null) {
            return EntitiesTitleResponse.EMPTY_RESPONSE;
        }
        Map<String, List<EntityIdentifier>> groupedByType = request.entities().stream().collect(Collectors.groupingBy(EntityIdentifier::type));
        Optional<EntitiesTitleResponse> entitiesTitleResponse = groupedByType.entrySet().stream().map(entry -> this.getTitlesForEntitiesFromSingleCollection(permissions, (String)entry.getKey(), (List)entry.getValue())).reduce(EntitiesTitleResponse::merge);
        return entitiesTitleResponse.orElse(EntitiesTitleResponse.EMPTY_RESPONSE);
    }

    private boolean matchesAdminIdAndUsersCollection(EntityIdentifier entity) {
        return entity.id().equals("local:admin") && entity.type().equals("users");
    }

    private boolean notMatchesAdminIdAndUsersCollection(EntityIdentifier entity) {
        return !this.matchesAdminIdAndUsersCollection(entity);
    }

    private EntitiesTitleResponse getTitlesForEntitiesFromSingleCollection(EntityPermissions permissions, String collection, List<EntityIdentifier> en) {
        Optional<DbEntityCatalogEntry> dbEntityCatalogEntry = this.entitiesCatalog.getByCollectionName(collection);
        if (dbEntityCatalogEntry.isEmpty() || en.isEmpty()) {
            return EntitiesTitleResponse.EMPTY_RESPONSE;
        }
        boolean adminIdAndUsersCollectionFound = en.stream().anyMatch(this::matchesAdminIdAndUsersCollection);
        List<EntityIdentifier> entities = adminIdAndUsersCollectionFound ? en.stream().filter(this::notMatchesAdminIdAndUsersCollection).toList() : en;
        HashSet<EntityTitleResponse> titles = new HashSet<EntityTitleResponse>();
        HashSet<String> notPermitted = new HashSet<String>();
        if (!entities.isEmpty()) {
            String titleField = dbEntityCatalogEntry.get().titleField();
            if (titleField.equals(TITLE_IF_NOT_PERMITTED)) {
                return new EntitiesTitleResponse(entities.stream().map(e -> new EntityTitleResponse(e.id(), e.type(), TITLE_IF_NOT_PERMITTED)).collect(Collectors.toSet()), Set.of());
            }
            MongoCollection mongoCollection = this.mongoConnection.getMongoDatabase().getCollection(collection);
            Bson bsonFilter = Filters.or((Iterable)entities.stream().map(e -> Filters.eq((String)"_id", (Object)new ObjectId(e.id()))).collect(Collectors.toList()));
            FindIterable documents = mongoCollection.find(bsonFilter).projection(Projections.include((String[])new String[]{titleField}));
            documents.forEach(doc -> {
                String idAsString = doc.getObjectId((Object)"_id").toString();
                boolean canReadTitle = this.checkCanReadTitle(permissions, ((DbEntityCatalogEntry)dbEntityCatalogEntry.get()).readPermission(), idAsString);
                titles.add(new EntityTitleResponse(idAsString, collection, canReadTitle ? doc.getString((Object)titleField) : TITLE_IF_NOT_PERMITTED));
                if (!canReadTitle) {
                    notPermitted.add(idAsString);
                }
            });
        }
        if (adminIdAndUsersCollectionFound) {
            titles.add(new EntityTitleResponse("local:admin", collection, "Administrator"));
        }
        return new EntitiesTitleResponse(titles, notPermitted);
    }

    private boolean checkCanReadTitle(EntityPermissions permissions, String readPermission, String idAsString) {
        return permissions.canReadTitle(readPermission, idAsString);
    }
}

