/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.indexer.requests;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import java.util.Objects;
import javax.annotation.Nullable;
import org.graylog2.datatiering.DataTieringConfig;
import org.graylog2.indexer.indexset.IndexSetConfig;
import org.graylog2.indexer.indexset.SimpleIndexSetConfig;
import org.graylog2.plugin.indexer.retention.RetentionStrategyConfig;
import org.graylog2.plugin.indexer.rotation.RotationStrategyConfig;
import org.graylog2.validation.ValidObjectId;
import org.joda.time.Duration;

@JsonAutoDetect
@JsonIgnoreProperties(ignoreUnknown=true)
public record IndexSetUpdateRequest(@JsonProperty(value="title") @NotBlank String title, @JsonProperty(value="description") @Nullable String description, @JsonProperty(value="writable") boolean isWritable, @JsonProperty(value="shards") @Min(value=1L) @Min(value=1L) int shards, @JsonProperty(value="replicas") @Min(value=0L) @Min(value=0L) int replicas, @JsonProperty(value="rotation_strategy_class") @Nullable String rotationStrategyClass, @JsonProperty(value="rotation_strategy") @Nullable RotationStrategyConfig rotationStrategyConfig, @JsonProperty(value="retention_strategy_class") @Nullable String retentionStrategyClass, @JsonProperty(value="retention_strategy") @Nullable RetentionStrategyConfig retentionStrategyConfig, @JsonProperty(value="index_optimization_max_num_segments") @Min(value=1L) @Min(value=1L) int indexOptimizationMaxNumSegments, @JsonProperty(value="index_optimization_disabled") boolean indexOptimizationDisabled, @JsonProperty(value="field_type_refresh_interval") Duration fieldTypeRefreshInterval, @JsonProperty(value="field_type_profile") @ValidObjectId @Nullable String fieldTypeProfile, @JsonProperty(value="data_tiering") @Nullable DataTieringConfig dataTieringConfig, @JsonProperty(value="use_legacy_rotation") @Nullable Boolean useLegacyRotation) implements SimpleIndexSetConfig
{
    @JsonProperty(value="use_legacy_rotation")
    @Nullable
    private final Boolean useLegacyRotation;

    public Boolean useLegacyRotation() {
        return Objects.isNull(this.useLegacyRotation) || this.useLegacyRotation != false;
    }

    public static IndexSetUpdateRequest fromIndexSetConfig(IndexSetConfig indexSet) {
        return new IndexSetUpdateRequest(indexSet.title(), indexSet.description(), indexSet.isWritable(), indexSet.shards(), indexSet.replicas(), indexSet.rotationStrategyClass(), indexSet.rotationStrategyConfig(), indexSet.retentionStrategyClass(), indexSet.retentionStrategyConfig(), indexSet.indexOptimizationMaxNumSegments(), indexSet.indexOptimizationDisabled(), indexSet.fieldTypeRefreshInterval(), indexSet.fieldTypeProfile(), indexSet.dataTieringConfig(), indexSet.dataTieringConfig() == null);
    }

    public IndexSetConfig toIndexSetConfig(String id, IndexSetConfig oldConfig) {
        return IndexSetConfig.builder().id(id).title(this.title()).description(this.description()).isWritable(this.isWritable()).isRegular(oldConfig.isRegular().orElse(null)).indexPrefix(oldConfig.indexPrefix()).indexMatchPattern(oldConfig.indexMatchPattern()).indexWildcard(oldConfig.indexWildcard()).shards(this.shards()).replicas(this.replicas()).rotationStrategyClass(this.rotationStrategyClass()).rotationStrategyConfig(this.rotationStrategyConfig()).retentionStrategyClass(this.retentionStrategyClass()).retentionStrategyConfig(this.retentionStrategyConfig()).creationDate(oldConfig.creationDate()).indexAnalyzer(oldConfig.indexAnalyzer()).indexTemplateName(oldConfig.indexTemplateName()).indexTemplateType(oldConfig.indexTemplateType().orElse(null)).indexOptimizationMaxNumSegments(this.indexOptimizationMaxNumSegments()).indexOptimizationDisabled(this.indexOptimizationDisabled()).fieldTypeRefreshInterval(this.fieldTypeRefreshInterval()).fieldTypeProfile(this.fieldTypeProfile()).customFieldMappings(oldConfig.customFieldMappings()).dataTieringConfig(Boolean.FALSE.equals(this.useLegacyRotation()) ? this.dataTieringConfig() : null).build();
    }
}

