/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.indexer.responses;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.time.ZonedDateTime;
import java.util.Optional;
import javax.annotation.Nullable;
import org.graylog2.datatiering.DataTieringConfig;
import org.graylog2.plugin.indexer.retention.RetentionStrategyConfig;
import org.graylog2.plugin.indexer.rotation.RotationStrategyConfig;
import org.graylog2.rest.resources.system.indexer.responses.DataTieringStatus;
import org.graylog2.rest.resources.system.indexer.responses.IndexSetSummary;
import org.graylog2.validation.SizeInBytes;
import org.joda.time.Duration;

abstract class $AutoValue_IndexSetSummary
extends IndexSetSummary {
    @Min(value=1L)
    private final @Min(value=1L) int shards;
    @Min(value=0L)
    private final @Min(value=0L) int replicas;
    @Nullable
    private final String rotationStrategyClass;
    @Nullable
    private final RotationStrategyConfig rotationStrategyConfig;
    @Nullable
    private final String retentionStrategyClass;
    @Nullable
    private final RetentionStrategyConfig retentionStrategyConfig;
    @Nullable
    private final DataTieringConfig dataTieringConfig;
    @Nullable
    private final String id;
    @NotBlank
    private final String title;
    @Nullable
    private final String description;
    private final boolean isDefault;
    private final boolean canBeDefault;
    private final boolean isWritable;
    @Pattern(regexp="^[a-z0-9][a-z0-9_+-]*$")
    @SizeInBytes(message="Index prefix must have a length in bytes between {min} and {max}", min=1, max=250)
    private final @Pattern(regexp="^[a-z0-9][a-z0-9_+-]*$") @SizeInBytes(message="Index prefix must have a length in bytes between {min} and {max}", min=1, max=250) String indexPrefix;
    @NotNull
    private final ZonedDateTime creationDate;
    @NotBlank
    private final String indexAnalyzer;
    @Min(value=1L)
    private final @Min(value=1L) int indexOptimizationMaxNumSegments;
    private final boolean indexOptimizationDisabled;
    private final Duration fieldTypeRefreshInterval;
    private final Optional<String> templateType;
    @Nullable
    private final String fieldTypeProfile;
    @Nullable
    private final Boolean useLegacyRotation;
    @Nullable
    private final DataTieringStatus dataTieringStatus;

    $AutoValue_IndexSetSummary(@Min(value=1L) @Min(value=1L) int shards, @Min(value=0L) @Min(value=0L) int replicas, @Nullable String rotationStrategyClass, @Nullable RotationStrategyConfig rotationStrategyConfig, @Nullable String retentionStrategyClass, @Nullable RetentionStrategyConfig retentionStrategyConfig, @Nullable DataTieringConfig dataTieringConfig, @Nullable String id, @NotBlank String title, @Nullable String description, boolean isDefault, boolean canBeDefault, boolean isWritable, @Pattern(regexp="^[a-z0-9][a-z0-9_+-]*$") @SizeInBytes(message="Index prefix must have a length in bytes between {min} and {max}", min=1, max=250) @Pattern(regexp="^[a-z0-9][a-z0-9_+-]*$") @SizeInBytes(message="Index prefix must have a length in bytes between {min} and {max}", min=1, max=250) String indexPrefix, @NotNull ZonedDateTime creationDate, @NotBlank String indexAnalyzer, @Min(value=1L) @Min(value=1L) int indexOptimizationMaxNumSegments, boolean indexOptimizationDisabled, Duration fieldTypeRefreshInterval, Optional<String> templateType, @Nullable String fieldTypeProfile, @Nullable Boolean useLegacyRotation, @Nullable DataTieringStatus dataTieringStatus) {
        this.shards = shards;
        this.replicas = replicas;
        this.rotationStrategyClass = rotationStrategyClass;
        this.rotationStrategyConfig = rotationStrategyConfig;
        this.retentionStrategyClass = retentionStrategyClass;
        this.retentionStrategyConfig = retentionStrategyConfig;
        this.dataTieringConfig = dataTieringConfig;
        this.id = id;
        if (title == null) {
            throw new NullPointerException("Null title");
        }
        this.title = title;
        this.description = description;
        this.isDefault = isDefault;
        this.canBeDefault = canBeDefault;
        this.isWritable = isWritable;
        if (indexPrefix == null) {
            throw new NullPointerException("Null indexPrefix");
        }
        this.indexPrefix = indexPrefix;
        if (creationDate == null) {
            throw new NullPointerException("Null creationDate");
        }
        this.creationDate = creationDate;
        if (indexAnalyzer == null) {
            throw new NullPointerException("Null indexAnalyzer");
        }
        this.indexAnalyzer = indexAnalyzer;
        this.indexOptimizationMaxNumSegments = indexOptimizationMaxNumSegments;
        this.indexOptimizationDisabled = indexOptimizationDisabled;
        if (fieldTypeRefreshInterval == null) {
            throw new NullPointerException("Null fieldTypeRefreshInterval");
        }
        this.fieldTypeRefreshInterval = fieldTypeRefreshInterval;
        if (templateType == null) {
            throw new NullPointerException("Null templateType");
        }
        this.templateType = templateType;
        this.fieldTypeProfile = fieldTypeProfile;
        this.useLegacyRotation = useLegacyRotation;
        this.dataTieringStatus = dataTieringStatus;
    }

    @Override
    @JsonProperty(value="shards")
    @Min(value=1L)
    public @Min(value=1L) int shards() {
        return this.shards;
    }

    @Override
    @JsonProperty(value="replicas")
    @Min(value=0L)
    public @Min(value=0L) int replicas() {
        return this.replicas;
    }

    @Override
    @JsonProperty(value="rotation_strategy_class")
    @Nullable
    public String rotationStrategyClass() {
        return this.rotationStrategyClass;
    }

    @Override
    @JsonProperty(value="rotation_strategy")
    @Nullable
    public RotationStrategyConfig rotationStrategyConfig() {
        return this.rotationStrategyConfig;
    }

    @Override
    @JsonProperty(value="retention_strategy_class")
    @Nullable
    public String retentionStrategyClass() {
        return this.retentionStrategyClass;
    }

    @Override
    @JsonProperty(value="retention_strategy")
    @Nullable
    public RetentionStrategyConfig retentionStrategyConfig() {
        return this.retentionStrategyConfig;
    }

    @Override
    @JsonProperty(value="data_tiering")
    @Nullable
    public DataTieringConfig dataTieringConfig() {
        return this.dataTieringConfig;
    }

    @Override
    @JsonProperty(value="id")
    @Nullable
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="title")
    @NotBlank
    public String title() {
        return this.title;
    }

    @Override
    @JsonProperty(value="description")
    @Nullable
    public String description() {
        return this.description;
    }

    @Override
    @JsonProperty(value="default")
    public boolean isDefault() {
        return this.isDefault;
    }

    @Override
    @JsonProperty(value="can_be_default")
    public boolean canBeDefault() {
        return this.canBeDefault;
    }

    @Override
    @JsonProperty(value="writable")
    public boolean isWritable() {
        return this.isWritable;
    }

    @Override
    @JsonProperty(value="index_prefix")
    @Pattern(regexp="^[a-z0-9][a-z0-9_+-]*$")
    @SizeInBytes(message="Index prefix must have a length in bytes between {min} and {max}", min=1, max=250)
    public @Pattern(regexp="^[a-z0-9][a-z0-9_+-]*$") @SizeInBytes(message="Index prefix must have a length in bytes between {min} and {max}", min=1, max=250) String indexPrefix() {
        return this.indexPrefix;
    }

    @Override
    @JsonProperty(value="creation_date")
    @NotNull
    public ZonedDateTime creationDate() {
        return this.creationDate;
    }

    @Override
    @JsonProperty(value="index_analyzer")
    @NotBlank
    public String indexAnalyzer() {
        return this.indexAnalyzer;
    }

    @Override
    @JsonProperty(value="index_optimization_max_num_segments")
    @Min(value=1L)
    public @Min(value=1L) int indexOptimizationMaxNumSegments() {
        return this.indexOptimizationMaxNumSegments;
    }

    @Override
    @JsonProperty(value="index_optimization_disabled")
    public boolean indexOptimizationDisabled() {
        return this.indexOptimizationDisabled;
    }

    @Override
    @JsonProperty(value="field_type_refresh_interval")
    public Duration fieldTypeRefreshInterval() {
        return this.fieldTypeRefreshInterval;
    }

    @Override
    @JsonProperty(value="index_template_type")
    public Optional<String> templateType() {
        return this.templateType;
    }

    @Override
    @JsonProperty(value="field_type_profile")
    @Nullable
    public String fieldTypeProfile() {
        return this.fieldTypeProfile;
    }

    @Override
    @JsonProperty(value="use_legacy_rotation")
    @Nullable
    public Boolean useLegacyRotation() {
        return this.useLegacyRotation;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="data_tiering_status")
    @Nullable
    public DataTieringStatus dataTieringStatus() {
        return this.dataTieringStatus;
    }

    public String toString() {
        return "IndexSetSummary{shards=" + this.shards + ", replicas=" + this.replicas + ", rotationStrategyClass=" + this.rotationStrategyClass + ", rotationStrategyConfig=" + this.rotationStrategyConfig + ", retentionStrategyClass=" + this.retentionStrategyClass + ", retentionStrategyConfig=" + this.retentionStrategyConfig + ", dataTieringConfig=" + this.dataTieringConfig + ", id=" + this.id + ", title=" + this.title + ", description=" + this.description + ", isDefault=" + this.isDefault + ", canBeDefault=" + this.canBeDefault + ", isWritable=" + this.isWritable + ", indexPrefix=" + this.indexPrefix + ", creationDate=" + this.creationDate + ", indexAnalyzer=" + this.indexAnalyzer + ", indexOptimizationMaxNumSegments=" + this.indexOptimizationMaxNumSegments + ", indexOptimizationDisabled=" + this.indexOptimizationDisabled + ", fieldTypeRefreshInterval=" + this.fieldTypeRefreshInterval + ", templateType=" + this.templateType + ", fieldTypeProfile=" + this.fieldTypeProfile + ", useLegacyRotation=" + this.useLegacyRotation + ", dataTieringStatus=" + this.dataTieringStatus + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof IndexSetSummary) {
            IndexSetSummary that = (IndexSetSummary)o;
            return this.shards == that.shards() && this.replicas == that.replicas() && (this.rotationStrategyClass == null ? that.rotationStrategyClass() == null : this.rotationStrategyClass.equals(that.rotationStrategyClass())) && (this.rotationStrategyConfig == null ? that.rotationStrategyConfig() == null : this.rotationStrategyConfig.equals(that.rotationStrategyConfig())) && (this.retentionStrategyClass == null ? that.retentionStrategyClass() == null : this.retentionStrategyClass.equals(that.retentionStrategyClass())) && (this.retentionStrategyConfig == null ? that.retentionStrategyConfig() == null : this.retentionStrategyConfig.equals(that.retentionStrategyConfig())) && (this.dataTieringConfig == null ? that.dataTieringConfig() == null : this.dataTieringConfig.equals(that.dataTieringConfig())) && (this.id == null ? that.id() == null : this.id.equals(that.id())) && this.title.equals(that.title()) && (this.description == null ? that.description() == null : this.description.equals(that.description())) && this.isDefault == that.isDefault() && this.canBeDefault == that.canBeDefault() && this.isWritable == that.isWritable() && this.indexPrefix.equals(that.indexPrefix()) && this.creationDate.equals(that.creationDate()) && this.indexAnalyzer.equals(that.indexAnalyzer()) && this.indexOptimizationMaxNumSegments == that.indexOptimizationMaxNumSegments() && this.indexOptimizationDisabled == that.indexOptimizationDisabled() && this.fieldTypeRefreshInterval.equals((Object)that.fieldTypeRefreshInterval()) && this.templateType.equals(that.templateType()) && (this.fieldTypeProfile == null ? that.fieldTypeProfile() == null : this.fieldTypeProfile.equals(that.fieldTypeProfile())) && (this.useLegacyRotation == null ? that.useLegacyRotation() == null : this.useLegacyRotation.equals(that.useLegacyRotation())) && (this.dataTieringStatus == null ? that.dataTieringStatus() == null : this.dataTieringStatus.equals(that.dataTieringStatus()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.shards;
        h$ *= 1000003;
        h$ ^= this.replicas;
        h$ *= 1000003;
        h$ ^= this.rotationStrategyClass == null ? 0 : this.rotationStrategyClass.hashCode();
        h$ *= 1000003;
        h$ ^= this.rotationStrategyConfig == null ? 0 : this.rotationStrategyConfig.hashCode();
        h$ *= 1000003;
        h$ ^= this.retentionStrategyClass == null ? 0 : this.retentionStrategyClass.hashCode();
        h$ *= 1000003;
        h$ ^= this.retentionStrategyConfig == null ? 0 : this.retentionStrategyConfig.hashCode();
        h$ *= 1000003;
        h$ ^= this.dataTieringConfig == null ? 0 : this.dataTieringConfig.hashCode();
        h$ *= 1000003;
        h$ ^= this.id == null ? 0 : this.id.hashCode();
        h$ *= 1000003;
        h$ ^= this.title.hashCode();
        h$ *= 1000003;
        h$ ^= this.description == null ? 0 : this.description.hashCode();
        h$ *= 1000003;
        h$ ^= this.isDefault ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.canBeDefault ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.isWritable ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.indexPrefix.hashCode();
        h$ *= 1000003;
        h$ ^= this.creationDate.hashCode();
        h$ *= 1000003;
        h$ ^= this.indexAnalyzer.hashCode();
        h$ *= 1000003;
        h$ ^= this.indexOptimizationMaxNumSegments;
        h$ *= 1000003;
        h$ ^= this.indexOptimizationDisabled ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.fieldTypeRefreshInterval.hashCode();
        h$ *= 1000003;
        h$ ^= this.templateType.hashCode();
        h$ *= 1000003;
        h$ ^= this.fieldTypeProfile == null ? 0 : this.fieldTypeProfile.hashCode();
        h$ *= 1000003;
        h$ ^= this.useLegacyRotation == null ? 0 : this.useLegacyRotation.hashCode();
        h$ *= 1000003;
        return h$ ^= this.dataTieringStatus == null ? 0 : this.dataTieringStatus.hashCode();
    }
}

