/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.processing;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.cluster.NodeService;
import org.graylog2.rest.RemoteInterfaceProvider;
import org.graylog2.rest.models.system.processing.ProcessingStatusSummary;
import org.graylog2.rest.resources.system.processing.RemoteSystemProcessingStatusResource;
import org.graylog2.shared.rest.resources.ProxiedResource;

@RequiresAuthentication
@Api(value="Cluster/Processing/Status")
@Path(value="/cluster/processing/status")
@Produces(value={"application/json"})
public class ClusterProcessingStatusResource
extends ProxiedResource {
    @Inject
    public ClusterProcessingStatusResource(NodeService nodeService, RemoteInterfaceProvider remoteInterfaceProvider, @Context HttpHeaders httpHeaders, @Named(value="proxiedRequestsExecutorService") ExecutorService executorService) {
        super(httpHeaders, nodeService, remoteInterfaceProvider, executorService);
    }

    @GET
    @Timed
    @ApiOperation(value="Get processing status from all nodes in the cluster")
    public Map<String, Optional<ProcessingStatusSummary>> getStatus() {
        return this.stripCallResult(this.requestOnAllNodes(RemoteSystemProcessingStatusResource.class, RemoteSystemProcessingStatusResource::getStatus));
    }

    @GET
    @Path(value="/persisted")
    @Timed
    @ApiOperation(value="Get persisted processing status from all nodes in the cluster")
    public Map<String, Optional<ProcessingStatusSummary>> getPersistedStatus() {
        return this.stripCallResult(this.requestOnAllNodes(RemoteSystemProcessingStatusResource.class, RemoteSystemProcessingStatusResource::getPersistedStatus));
    }
}

