/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security;

import com.github.joschi.jadconfig.util.Duration;
import com.google.common.base.Suppliers;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.security.Key;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.graylog2.security.JwtSecret;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class IndexerJwtAuthTokenProvider
implements Provider<String> {
    private final Supplier<String> authHeaderBearerString;
    private static final Logger LOG = LoggerFactory.getLogger(IndexerJwtAuthTokenProvider.class);

    @Inject
    public IndexerJwtAuthTokenProvider(JwtSecret jwtSecret, @Named(value="indexer_jwt_auth_token_expiration_duration") Duration tokenExpirationDuration, @Named(value="indexer_jwt_auth_token_caching_duration") Duration cachingDuration) {
        this.authHeaderBearerString = Suppliers.memoizeWithExpiration(() -> {
            LOG.debug("Creating new JWT token, expiration set to {}", (Object)tokenExpirationDuration);
            return "Bearer " + IndexerJwtAuthTokenProvider.createToken(jwtSecret, tokenExpirationDuration);
        }, (long)cachingDuration.toSeconds(), (TimeUnit)TimeUnit.SECONDS);
    }

    public static String createToken(JwtSecret jwtSecret, Duration tokenExpirationDuration) {
        long nowMillis = System.currentTimeMillis();
        Date now = new Date(nowMillis);
        JwtBuilder builder = Jwts.builder().id("graylog datanode connect " + nowMillis).claims(Map.of("os_roles", "admin")).issuedAt(now).subject("admin").issuer("graylog").notBefore(now).expiration(new Date(nowMillis + tokenExpirationDuration.toMilliseconds())).signWith((Key)jwtSecret.getSigningKey());
        return builder.compact();
    }

    public String get() {
        return this.authHeaderBearerString.get();
    }
}

