/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.graylog2.security.JwtSecret;

@Singleton
public class JwtSecretProvider
implements Provider<JwtSecret> {
    private final JwtSecret jwtSecret;

    @Inject
    public JwtSecretProvider(@Named(value="password_secret") String passwordSecret) {
        this.jwtSecret = new JwtSecret(this.adaptPassword(passwordSecret));
    }

    private String adaptPassword(String passwordSecret) {
        if (passwordSecret.length() < 64) {
            String extended = passwordSecret + StringUtils.repeat((String)passwordSecret, (int)3);
            return extended.substring(0, 64);
        }
        return passwordSecret;
    }

    public JwtSecret get() {
        return this.jwtSecret;
    }
}

