/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security;

import com.google.common.collect.Lists;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Indexes;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.shiro.session.mgt.SimpleSession;
import org.bson.types.ObjectId;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PersistedServiceImpl;
import org.graylog2.events.ClusterEventBus;
import org.graylog2.plugin.database.Persisted;
import org.graylog2.security.MongoDBSessionService;
import org.graylog2.security.MongoDbSession;
import org.graylog2.security.SessionDeletedEvent;

@Singleton
public class MongoDBSessionServiceImpl
extends PersistedServiceImpl
implements MongoDBSessionService {
    private final ClusterEventBus eventBus;

    @Inject
    public MongoDBSessionServiceImpl(MongoConnection mongoConnection, ClusterEventBus clusterEventBus) {
        super(mongoConnection);
        this.eventBus = clusterEventBus;
        MongoDatabase database = mongoConnection.getMongoDatabase();
        MongoCollection sessions = database.getCollection("sessions");
        sessions.createIndex(Indexes.ascending((String[])new String[]{"session_id"}));
    }

    @Override
    @Nullable
    public MongoDbSession load(String sessionId) {
        BasicDBObject query = new BasicDBObject();
        query.put("session_id", (Object)sessionId);
        DBObject result = this.findOne(MongoDbSession.class, (DBObject)query);
        if (result == null) {
            return null;
        }
        Object objectId = result.get("_id");
        return new MongoDbSession((ObjectId)objectId, result.toMap());
    }

    @Override
    public Collection<MongoDbSession> loadAll() {
        BasicDBObject query = new BasicDBObject();
        ArrayList dbSessions = Lists.newArrayList();
        List<DBObject> sessions = this.query(MongoDbSession.class, (DBObject)query);
        for (DBObject session : sessions) {
            dbSessions.add(new MongoDbSession((ObjectId)session.get("_id"), session.toMap()));
        }
        return dbSessions;
    }

    @Override
    public SimpleSession daoToSimpleSession(MongoDbSession sessionDAO) {
        SimpleSession session = new SimpleSession();
        session.setId((Serializable)((Object)sessionDAO.getSessionId()));
        session.setHost(sessionDAO.getHost());
        session.setTimeout(sessionDAO.getTimeout());
        session.setStartTimestamp(sessionDAO.getStartTimestamp());
        session.setLastAccessTime(sessionDAO.getLastAccessTime());
        session.setExpired(sessionDAO.isExpired());
        session.setAttributes(sessionDAO.getAttributes());
        return session;
    }

    @Override
    public <T extends Persisted> int destroy(T model) {
        int affectedDocs = super.destroy(model);
        if (affectedDocs != 0 && model instanceof MongoDbSession) {
            MongoDbSession session = (MongoDbSession)model;
            this.eventBus.post(new SessionDeletedEvent(session.getSessionId()));
        }
        return affectedDocs;
    }
}

