/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

@Singleton
public class SafeClasses {
    private final Set<String> prefixes;

    public static SafeClasses allGraylogInternal() {
        return new SafeClasses(Set.of("org.graylog.", "org.graylog2."));
    }

    @Inject
    public SafeClasses(@Named(value="safe_classes") @Nonnull Set<String> prefixes) {
        this.prefixes = Objects.requireNonNull(prefixes);
    }

    public boolean isSafeToLoad(String className) {
        return this.prefixes.stream().anyMatch(className::startsWith);
    }
}

