/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.bindings.providers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.graylog.grn.GRNRegistry;
import org.graylog2.jackson.InputConfigurationBeanDeserializerModifier;
import org.graylog2.plugin.inject.JacksonSubTypes;
import org.graylog2.security.encryption.EncryptedValueService;
import org.graylog2.shared.bindings.providers.config.ObjectMapperConfiguration;
import org.graylog2.shared.plugins.GraylogClassLoader;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ObjectMapperProvider
implements Provider<ObjectMapper> {
    private static final Logger log = LoggerFactory.getLogger(ObjectMapperProvider.class);
    protected final ObjectMapper objectMapper;
    private final LoadingCache<DateTimeZone, ObjectMapper> mapperByTimeZone = CacheBuilder.newBuilder().maximumSize((long)DateTimeZone.getAvailableIDs().size()).build((CacheLoader)new CacheLoader<DateTimeZone, ObjectMapper>(){

        public ObjectMapper load(@Nonnull DateTimeZone key) {
            return ObjectMapperProvider.this.objectMapper.copy().setTimeZone(key.toTimeZone());
        }
    });

    public ObjectMapperProvider() {
        this(ObjectMapperProvider.class.getClassLoader(), Collections.emptySet(), new EncryptedValueService(UUID.randomUUID().toString()), GRNRegistry.createWithBuiltinTypes(), InputConfigurationBeanDeserializerModifier.withoutConfig());
    }

    public ObjectMapperProvider(ClassLoader classLoader, Set<NamedType> subtypes) {
        this(classLoader, subtypes, new EncryptedValueService(UUID.randomUUID().toString()), GRNRegistry.createWithBuiltinTypes(), InputConfigurationBeanDeserializerModifier.withoutConfig());
    }

    @Inject
    public ObjectMapperProvider(@GraylogClassLoader ClassLoader classLoader, @JacksonSubTypes Set<NamedType> subtypes, EncryptedValueService encryptedValueService, GRNRegistry grnRegistry, InputConfigurationBeanDeserializerModifier inputConfigurationBeanDeserializerModifier) {
        ObjectMapper mapper = new ObjectMapper();
        this.objectMapper = ObjectMapperConfiguration.configureMapper(mapper, classLoader, subtypes, encryptedValueService, grnRegistry, inputConfigurationBeanDeserializerModifier);
    }

    public ObjectMapper get() {
        return this.objectMapper;
    }

    public ObjectMapper getForTimeZone(DateTimeZone timeZone) {
        if (timeZone != null) {
            try {
                return (ObjectMapper)this.mapperByTimeZone.get((Object)timeZone);
            }
            catch (Exception e) {
                log.error("Unable to get ObjectMapper for time zone <" + timeZone + ">. Using UTC ObjectMapper instead.", (Throwable)e);
            }
        }
        return this.objectMapper;
    }
}

