/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.messageq.localkafka;

import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.Retryer;
import com.google.common.util.concurrent.AbstractIdleService;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.graylog2.shared.buffers.RawMessageEvent;
import org.graylog2.shared.journal.Journal;
import org.graylog2.shared.journal.LocalKafkaJournal;
import org.graylog2.shared.messageq.MessageQueueException;
import org.graylog2.shared.messageq.MessageQueueWriter;
import org.graylog2.shared.messageq.localkafka.JournalRetryerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class LocalKafkaMessageQueueWriter
extends AbstractIdleService
implements MessageQueueWriter {
    private static final Logger LOG = LoggerFactory.getLogger(LocalKafkaMessageQueueWriter.class);
    private LocalKafkaJournal kafkaJournal;
    private Semaphore journalFilled;
    private final MessageQueueWriter.Metrics metrics;
    private final Retryer<Void> writeRetryer;

    @Inject
    public LocalKafkaMessageQueueWriter(LocalKafkaJournal kafkaJournal, @Named(value="JournalSignal") Semaphore journalFilled, MessageQueueWriter.Metrics metrics) {
        this.kafkaJournal = kafkaJournal;
        this.journalFilled = journalFilled;
        this.metrics = metrics;
        this.writeRetryer = JournalRetryerFactory.create(this.retryerExceptionPredicate());
    }

    @Override
    public void write(List<RawMessageEvent> entries) throws MessageQueueException {
        AtomicLong msgBytes = new AtomicLong(0L);
        List<Journal.Entry> journalEntries = entries.stream().filter(Objects::nonNull).map(e -> new Journal.Entry(e.getMessageIdBytes(), e.getEncodedRawMessage())).peek(e -> msgBytes.addAndGet(e.getMessageBytes().length)).collect(Collectors.toList());
        try {
            this.writeToJournal(journalEntries);
        }
        catch (Exception e2) {
            LOG.error("Unable to write to journal - retrying", (Throwable)e2);
            try {
                this.writeRetryer.call(() -> {
                    this.writeToJournal(journalEntries);
                    return null;
                });
            }
            catch (RetryException | ExecutionException ex) {
                throw new MessageQueueException("Retryer exception", ex);
            }
        }
        this.metrics.writtenMessages().mark((long)journalEntries.size());
        this.metrics.writtenBytes().mark(msgBytes.get());
    }

    private void writeToJournal(List<Journal.Entry> entries) {
        long lastOffset = this.kafkaJournal.write(entries);
        LOG.debug("Processed batch, last journal offset: {}, signalling reader.", (Object)lastOffset);
        this.journalFilled.release();
    }

    private Predicate<Throwable> retryerExceptionPredicate() {
        return exception -> {
            LOG.error("Unable to write to journal - retrying with exponential back-off", exception);
            this.metrics.failedWriteAttempts().mark();
            return true;
        };
    }

    protected void startUp() throws Exception {
    }

    protected void shutDown() throws Exception {
    }
}

