/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.rest.exceptionmappers;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.fasterxml.jackson.databind.exc.PropertyBindingException;
import com.fasterxml.jackson.databind.exc.ValueInstantiationException;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.graylog2.plugin.rest.RequestError;

@Provider
public class JsonMappingExceptionMapper
implements ExceptionMapper<JsonMappingException> {
    public Response toResponse(JsonMappingException e) {
        String errorPath = this.errorPath(e);
        JsonLocation location = e.getLocation();
        String message = this.errorWithJsonPath(e, errorPath);
        String referencePath = this.referencePath(e);
        RequestError apiError = RequestError.create(message, location.getLineNr(), location.getColumnNr(), errorPath, referencePath);
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)apiError).build();
    }

    private String referencePath(JsonMappingException e) {
        StringBuilder sb = new StringBuilder().append(e.getPathReference());
        if (e instanceof ValueInstantiationException) {
            ValueInstantiationException vie = (ValueInstantiationException)e;
            if (!sb.isEmpty()) {
                sb.append("->");
            }
            sb.append(vie.getType().getRawClass().getCanonicalName());
        }
        return sb.toString();
    }

    private String errorPath(JsonMappingException e) {
        return e.getPath().stream().map(path -> {
            String fieldName = path.getFieldName();
            if (fieldName == null && path.getIndex() != -1) {
                return "[" + path.getIndex() + "]";
            }
            return fieldName;
        }).collect(Collectors.joining("."));
    }

    private String errorWithJsonPath(JsonMappingException e, String path) {
        String location = "[" + e.getLocation().getLineNr() + ", " + e.getLocation().getColumnNr() + "]";
        String quotedPath = "\"" + path + "\"";
        String messagePrefix = "Error at " + quotedPath + " " + location;
        if (e instanceof PropertyBindingException) {
            PropertyBindingException propertyBindingException = (PropertyBindingException)e;
            Collection knownPropertyIds = (Collection)MoreObjects.firstNonNull((Object)propertyBindingException.getKnownPropertyIds(), Collections.emptyList());
            StringBuilder message = new StringBuilder("Unable to map property ").append(propertyBindingException.getPropertyName()).append(".\nKnown properties include: ");
            Joiner.on((String)", ").appendTo(message, (Iterable)knownPropertyIds);
            return message.toString();
        }
        if (e instanceof MismatchedInputException) {
            MismatchedInputException mismatchedInputException = (MismatchedInputException)e;
            Class targetType = mismatchedInputException.getTargetType();
            if (targetType != null) {
                return messagePrefix + ": Must be of type " + mismatchedInputException.getTargetType().getSimpleName();
            }
            return messagePrefix + ": " + mismatchedInputException.getMessage();
        }
        Throwable cause = e.getCause();
        String problemMessage = ((Throwable)MoreObjects.firstNonNull((Object)cause, (Object)((Object)e))).getMessage();
        String message = (String)MoreObjects.firstNonNull((Object)problemMessage, (Object)"Couldn't process JSON input");
        return messagePrefix + ": " + message;
    }
}

