/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.rest.resources.documentation;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.Configuration;
import org.graylog2.configuration.HttpConfiguration;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.rest.RestTools;
import org.graylog2.shared.plugins.DocumentationRestResourceClasses;
import org.graylog2.shared.rest.documentation.generator.Generator;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.shared.rest.resources.csp.CSP;

@Api(value="Documentation", description="Documentation of this API in JSON format.")
@Path(value="/api-docs")
@CSP(group="swagger")
@RequiresAuthentication
public class DocumentationResource
extends RestResource {
    private final Generator generator;
    private final HttpConfiguration httpConfiguration;

    @Inject
    public DocumentationResource(HttpConfiguration httpConfiguration, ObjectMapper objectMapper, DocumentationRestResourceClasses documentationRestResourceClasses, Configuration configuration) {
        this.httpConfiguration = Objects.requireNonNull(httpConfiguration, "httpConfiguration");
        ImmutableSet.Builder resourceClasses = ImmutableSet.builder().addAll(documentationRestResourceClasses.getSystemResources());
        HashMap pluginRestControllerMapping = new HashMap();
        for (Map.Entry<String, Set<Class<? extends PluginRestResource>>> entry : documentationRestResourceClasses.getPluginResourcesMap().entrySet()) {
            String pluginPackage = entry.getKey();
            resourceClasses.addAll((Iterable)entry.getValue());
            for (Class<? extends PluginRestResource> pluginRestResource : entry.getValue()) {
                pluginRestControllerMapping.put(pluginRestResource, pluginPackage);
            }
        }
        this.generator = new Generator((Set<Class<?>>)resourceClasses.build(), pluginRestControllerMapping, "/plugins", objectMapper, configuration.isCloud());
    }

    @GET
    @Timed
    @ApiOperation(value="Get API documentation")
    @Produces(value={"application/json"})
    public Response overview() {
        return this.buildSuccessfulCORSResponse(this.generator.generateOverview());
    }

    @GET
    @Timed
    @ApiOperation(value="Get API documentation with cluster global URI path")
    @Produces(value={"application/json"})
    @Path(value="/global")
    public Response globalOverview() {
        return this.buildSuccessfulCORSResponse(this.generator.generateOverview());
    }

    @GET
    @Timed
    @ApiOperation(value="Get detailed API documentation of a single resource")
    @Produces(value={"application/json"})
    @Path(value="/{route: .+}")
    public Response route(@ApiParam(name="route", value="Route to fetch. For example /system", required=true) @PathParam(value="route") String route, @Context HttpHeaders httpHeaders) {
        URI baseUri;
        if (route.startsWith("global")) {
            route = route.replace("global", "");
            baseUri = RestTools.buildRelativeExternalUri((MultivaluedMap<String, String>)httpHeaders.getRequestHeaders(), this.httpConfiguration.getHttpExternalUri()).resolve("api/");
        } else {
            baseUri = this.httpConfiguration.getHttpPublishUri().resolve("api/");
        }
        return this.buildSuccessfulCORSResponse(this.generator.generateForRoute(route, baseUri.toString()));
    }

    private Response buildSuccessfulCORSResponse(Map<String, Object> result) {
        return Response.ok(result).header("Access-Control-Allow-Origin", (Object)"*").header("Access-Control-Allow-Methods", (Object)"GET").header("Access-Control-Allow-Headers", (Object)"Content-Type, api_key, Authorization").build();
    }
}

