/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.rest.resources.system;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.ArrayList;
import java.util.Set;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.plugin.Capabilities;
import org.graylog2.plugin.PluginMetaData;
import org.graylog2.rest.models.system.plugins.responses.PluginList;
import org.graylog2.rest.models.system.plugins.responses.PluginMetaDataValue;
import org.graylog2.shared.rest.resources.RestResource;

@Api(value="System/Plugins", description="Plugin information")
@Path(value="/system/plugins")
@Produces(value={"application/json"})
@RequiresAuthentication
public class SystemPluginResource
extends RestResource {
    private final Set<PluginMetaData> pluginMetaDataSet;

    @Inject
    public SystemPluginResource(Set<PluginMetaData> pluginMetaDataSet) {
        this.pluginMetaDataSet = pluginMetaDataSet;
    }

    @GET
    @Timed
    @ApiOperation(value="List all installed plugins on this node.")
    public PluginList list() {
        ArrayList pluginMetaDataValues = Lists.newArrayList();
        for (PluginMetaData pluginMetaData : this.pluginMetaDataSet) {
            pluginMetaDataValues.add(PluginMetaDataValue.create(pluginMetaData.getUniqueId(), pluginMetaData.getName(), pluginMetaData.getAuthor(), pluginMetaData.getURL(), pluginMetaData.getVersion().toString(), pluginMetaData.getDescription(), pluginMetaData.getRequiredVersion().toString(), Capabilities.toStringSet(pluginMetaData.getRequiredCapabilities())));
        }
        return PluginList.create(pluginMetaDataValues);
    }
}

