/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.system.traffic;

import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.graylog2.plugin.system.NodeId;
import org.joda.time.DateTime;

public interface TrafficUpdater {
    public void updateTraffic(DateTime var1, NodeId var2, long var3, long var5, long var7);

    public static DateTime getDayBucketStart(DateTime observationTime) {
        return observationTime.withHourOfDay(0).withMinuteOfHour(0).withSecondOfMinute(0).withMillisOfSecond(0);
    }

    public static DateTime getHourBucketStart(DateTime observationTime) {
        return observationTime.withMinuteOfHour(0).withSecondOfMinute(0).withMillisOfSecond(0);
    }

    public static Map<DateTime, Long> aggregateToDaily(Map<DateTime, Long> histogram) {
        return histogram.entrySet().stream().collect(Collectors.groupingBy(entry -> ((DateTime)entry.getKey()).withTimeAtStartOfDay(), TreeMap::new, Collectors.mapping(Map.Entry::getValue, Collectors.summingLong(Long::valueOf))));
    }
}

