/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.utilities;

import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.util.List;
import java.util.Map;

public class LenientExplicitOrdering<T>
extends Ordering<T> {
    private final Map<T, Integer> idxMap;

    public LenientExplicitOrdering(List<T> order) {
        this.idxMap = Maps.newHashMapWithExpectedSize((int)order.size());
        int idx = 0;
        for (T s : order) {
            this.idxMap.put(s, idx);
            ++idx;
        }
    }

    public int compare(T left, T right) {
        Integer leftIdx = this.idxMap.get(left);
        Integer rightIdx = this.idxMap.get(right);
        if (leftIdx != null && rightIdx != null) {
            return Integer.compare(leftIdx, rightIdx);
        }
        if (left instanceof Comparable && leftIdx == null && rightIdx == null) {
            return ((Comparable)left).compareTo(right);
        }
        if (leftIdx == null) {
            return -1;
        }
        return 1;
    }
}

