/*
 * Decompiled with CFR 0.152.
 */
package org.mongojack;

import com.google.common.primitives.Ints;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCursor;
import jakarta.annotation.Nonnull;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.concurrent.NotThreadSafe;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.mongojack.JacksonMongoCollection;

@Deprecated
@NotThreadSafe
public class DBCursor<T>
implements Closeable,
Iterator<T>,
Iterable<T> {
    private final JacksonMongoCollection<T> collection;
    private final FindIterable<T> findIterable;
    private final Bson filter;
    private MongoCursor<T> cursor;

    public DBCursor(JacksonMongoCollection<T> collection, Bson filter, Supplier<FindIterable<T>> findIterableSupplier) {
        this.collection = collection;
        this.findIterable = findIterableSupplier.get();
        this.filter = filter;
    }

    public DBCursor<T> sort(Bson sort) {
        this.findIterable.sort(sort);
        this.refreshCursor();
        return this;
    }

    public DBCursor<T> limit(int limit) {
        this.findIterable.limit(limit);
        this.refreshCursor();
        return this;
    }

    public DBCursor<T> skip(int skip) {
        this.findIterable.skip(skip);
        this.refreshCursor();
        return this;
    }

    @Override
    public void close() {
        if (this.cursor != null) {
            this.cursor.close();
        }
    }

    public List<T> toArray() {
        return (List)this.findIterable.into(new ArrayList());
    }

    @Override
    public boolean hasNext() {
        return this.getCursor().hasNext();
    }

    @Override
    public T next() {
        return (T)this.getCursor().next();
    }

    private MongoCursor<T> getCursor() {
        if (this.cursor == null) {
            this.cursor = this.findIterable.iterator();
        }
        return this.cursor;
    }

    private void refreshCursor() {
        if (this.cursor != null) {
            this.cursor.close();
            this.cursor = null;
        }
    }

    public int count() {
        return Ints.saturatedCast((long)this.collection.countDocuments(this.filter));
    }

    @Override
    @Nonnull
    public Iterator<T> iterator() {
        return new DBCursor<T>(this.collection, this.filter, () -> this.findIterable);
    }

    public Document explain() {
        return this.findIterable.explain();
    }
}

